/**
 * Class: Map
 */

/**
 * Method: new
 */
function Map(facility_id,options){
	
	var data = JSON.parse(localStorage.getItem('data'));
	
	if (!facility_id) throw 'No facility ID!';
	this.facility = data.hash.facilities[facility_id];
	
	if (!this.facility.jpg_id) throw 'No facility PDF!';
	
	var pdfs = this.LS.get('images') || {};

	var native_url = pdfs[this.facility.jpg_id];
	if (native_url) {
		this._loaded = 1;
		this.jpg_url = native_url;
	} else {
		this._loaded  = 0;
		this.jpg_url = lnrr.server + this.facility.jpg_url;
	}
		
	options = options  || {};
	options.title = 'Просмотр чертежа';
	
	this.size = 1;
	console.log('this.init(options);');
	this.init(options);
	
}

Map.prototype = new Page();

/**
 * Method: my_name
 */
Map.prototype.my_name = function(){
	return 'Map';
}

/**
 * Method: gen_layout_custom
 */
Map.prototype.gen_layout_custom = function(ret){
	if(!this._loaded) ret.top.buttons.push({ pos:100, name:"", cssclass:"image download", click:function(){ pager.fire('load_image'); } });
	ret.bottom = {
		buttons:[
			{ pos:100, name:"+", cssclass:"", click:function(){ pager.fire('inc_size',1); } },
			{ pos:50, name:"Фильтры", cssclass:"", click:function(){ pager.fire('switch_filters'); } },	
			{ pos:0, name:"-", cssclass:"", click:function(){ pager.fire('inc_size',-1); } }		 
		]	
	};
}

/**
 * Method: before_open
 */
Map.prototype.before_open = function(v){
	lnrr.dictionaries = JSON.parse(localStorage.getItem('dictionaries'));
	lnrr._loaded = this._loaded;
}

/**
 * Method: refresh
 */
Map.prototype.refresh = function(){
	
}

/**
 * Method: after_page_added
 */
Map.prototype.after_page_added = function(){
	
	var t = this;
	
	this.html.addClass('wide');
	
	this.blocks['filters'] = $('.Map_filters',this.html);
	this.blocks['elements'] = $('.elements',this.html);
	this.blocks['map'] = $('.map',this.html);
	
	console.log(this);
	this.set_loader(1);
	
	this.img = new Image();
	this.img.onload = function(){
		console.log('this.img.onload');
		t.set_loader(0);
		t.blocks['map'].css({ 'background-image':'url(' + t.jpg_url + ')' });
		t.refresh_img();
	}
	
	this.img.src = this.jpg_url;
}

/**
 * Method: inc_size
 */
Map.prototype.inc_size = function(v){
	this.size += 0.075*v;
	this.refresh_img();
}


/**
 * Method: render_svg
 */
Map.prototype.render_svg = function(){
	
	var t = this;
	
	console.log('render_svg');
	
	lnrr.width = t.img.width * t.size;
	lnrr.height = t.img.height * t.size;
	
	lnrr.sensor_size = this.size * (this.facility.element_size || 1);
	
	var filters = this.gen_filters();
	
	var get_pos = function(arr,el,type){
		if (!t.check(el,type,filters)) return arr;
		arr.push({
			
			allowed_model_type_code:	el.allowed_model_type_code,
			state_code:					el.state_code,
			x:							el.location_x * t.size - 50*lnrr.sensor_size/2,
			y:							el.location_y * t.size - 50*lnrr.sensor_size/2,
			type: 						type=='facility' ? 'facilities' : 'sensors',
			id:							el.id,
			name:						el.name,
			a:						el.angle || 0,
		});
		return arr;
	}
	
	var get_pos_f = function(arr,el){ return get_pos(arr,el,'facility'); }
	
	lnrr.items = this.facility
		.sensors
		.reduce(get_pos,[]);
		
	lnrr.items = this.facility
		.facilities
		.reduce(get_pos_f,lnrr.items);
	
	this.blocks['elements'].html(this.get_view('svg'));
	
	console.log('render_svg done');
}
	

/**
 * Method: refresh_img
 */
Map.prototype.refresh_img = function(){
	
	var t = this;
	
	if (this._load) return;
	this._load = 1;
	
	this.set_loader(1);
	
	console.log('refresh_img');
	
	this.blocks['elements'].html('');
	t.blocks['map'].css({
		width:	t.img.width*t.size,
		height:	t.img.height*t.size,
	});
	
	this.render_svg();
	
	this.set_loader(0);
	this._load = 0;
}

/**
 * Method: switch_filters
 */
Map.prototype.switch_filters = function(v){
	this.blocks.filters.toggleClass('A');
}

/**
 * Method: switch_cb
 */
Map.prototype.switch_cb = function(cb){
	cb.toggleClass('A');	
	this.refresh_img();
}

/**
 * Method: check
 */
Map.prototype.check = function(item,type,filters){
	var id = item.id;
	var data = JSON.parse(localStorage.getItem('data'));
	
	if (type != 'facility') {
		var model_id = data.hash.AllowedModelType[item.allowed_model_type_id].sensor_model_id;
//		if (!filters.all_sensors && !filters.sensors[id]) return false;
		if (!filters.all_sensor_states && !filters.sensor_states[item.state_id]) return false;
		if (!filters.all_sensor_models && !filters.sensor_models[model_id]) return false;
		if (filters.retranslator && !item.is_retranslator) return false;
		if (item.deleted) return false;
		return true;
	}
	//if (type == 'facility') {
	//	if (!filters.all_facilities && !filters.facilities[id]) return false;
	//	return true;
	//}
	return true;
}


/**
 * Method: gen_filters
 */
Map.prototype.gen_filters = function(cb){
	var tag = this.blocks.filters;
	var filters = {};
	[
	 '.filter[data-name=sensor_models]',
	 '.filter[data-name=sensor_states]',
	 '.list[data-name=sensors]',
	 '.list[data-name=facilities]',
	].forEach(function(el){
		var block = $(el,tag);
		var k = block.attr('data-name');
		var list = $('.cb.A',block);
		filters[k] = {};
		if (!list.length) filters['all_'+k]=1;
		list.each(function(){filters[k][$(this).attr('data-id')]=1;})
	});
	filters.retranslator = $('.filter[data-name=retranslator] .cb',tag).hasClass('A');
	return filters;
}


/**
 * Method: load_image
 */
Map.prototype.load_image = function(){
	var t = this;
	this.set_loader(1);
	this.save_image({
		id: t.facility.jpg_id,
		url: lnrr.server + t.facility.jpg_url,
	},function(){
		pager.add_object(new Map(t.facility.id,{ page_index:pager.pages-1 }));
	});
}

