#ifndef ATOMS_BLOB_H
#define ATOMS_BLOB_H

#include <atoms/text.h>

uint32 ptr_word_align(uint32 i);

class Text8;
class Text32;
/*! \brief Класс хранящий поток байт.
 *  \ingroup atoms
 */
class Blob: public Text {
public:
	Blob();
	Blob(Text*t);
	Blob(const char *chr);
	Blob(const char *chr,uint32 size);
	Blob(uint8 *chr,uint32 size);
	virtual ~Blob();
	virtual void init_from_text8 (Text8 *txt);
	virtual void init_from_text32(Text32 *txt);
	virtual void init_from_blob  (Blob *txt);
	virtual Text *concat(Text *txt);
	virtual void add(Text *txt);
	virtual void add(const char *txt);
	virtual void add(const uint8* buf, uint32 len);
	virtual void add_bytes(const uint8* buf, uint32 len);
	virtual Text *substr(uint32 start,uint32 len);
	virtual const char *classname();
	virtual int8 cmp(Object *txt);
	virtual char *get_chars();
	virtual int32 index_of(Text *substr,uint32 pos=0);
	virtual int32 index_of(const char *text2,uint32 size,uint32 pos);
	virtual Array *split(Text *substr);
	virtual Array *split(const char *text2,uint32 size2);
	virtual uint32 get_char(uint32 pos);
	virtual bool starts_with(Text *substr);
	virtual void print();
	virtual void print(FILE *out);
	
	void byte_print();

	virtual char *ptr();
	virtual uint32 size_in_bytes();

	virtual void word_align();

	uint8 *text;
	uint32 length_real;
protected:
};

#endif
