#ifndef ATOMS_STORABLE_H
#define ATOMS_STORABLE_H

#include <atoms.h>

class Storable;
extern Storable *storable;

void storable_init(void);

typedef Object *(Fparse_text_item)(Text *b,uint32 cmd,uint32 p1,Object *o);
typedef Object *(Fparse_blob_item)(Blob *b,uint32 cmd,uint32 p1,Object *o);

//Object *from_blob_iterator(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level=0);
typedef Object *(Ffrom_blob)(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level);

class StorableFromBlob;
class StorableFromJson;

class Storable: public Object {
	public:
		Storable();
		virtual ~Storable();
		
		virtual const char *classname();

		virtual Text8 *to_json(Object *o);
		virtual Object *from_json(Text8 *src);
		
		virtual Blob *to_blob(Object *o);
		virtual Object *from_blob(Blob *b);
		virtual Object *from_blob(const uint8 *src,uint32 len);
		virtual Object *from_blob_item(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level=0);

		virtual void set_from_blob_constructor(uint32 code,StorableFromBlob *f);
//		virtual void set_from_json_constructor(uint32 code,StorableFromJson *f);
		Array *from_blobs;
//		Array *from_jsons;
};

class StorableFromBlob: public Object {
	public:
		StorableFromBlob();
		virtual ~StorableFromBlob();
		
		virtual const char *classname()=0;
		virtual Object *from(const uint8 *src,uint32 len,uint32 &posinc,uint8 &error,uint32 level)=0;
};

//Object *from_blob(const uint8 *src,uint32 len);


#endif

