//utf.h
/*! \brief Преобразования символов utf8 в utf32 и обратно. Сравнения символов.
*/

#ifndef UTF_H
#define UTF_H

#include <atoms.h>

/*! \brief Функция истинна, если в представленной поcледовательности первые 1-6 байт образуют символ уникода в кодировке utf8.
*/
extern bool issymbol (uint8* b, int len); 

/*! \brief Сравнение символа, представленного последовательностью utf8 с символом utf32  
*/
extern bool comparesym (uint8* b, int len, uint32);

extern uint32 symbol (uint8* b, int len);

extern void print64 (uint64 u);

extern void print_arr (uint8* p, int len);

extern bool msg_return (const char* msg, bool ret);
#endif
