#ifndef OFFERMON_MEMCACHE_H
#define OFFERMON_MEMCACHE_H

#include <pcre.h>

#include "omatoms.h"
#include "streams.h"

#define REGIONS_SIZE 100

void time_elapsed_start();
void time_elapsed_end(const char *name);

class Tracker;

class Offer:public Object {
	public:
		int64			id;
		char*			tracking_url;
		int64			engine_id;
//		char*			regions;
		char			regions[REGIONS_SIZE];
		int64			devices;
		bool			do_free;
		int				regions_size;
		char*			app_name;
		char*			app_description;
		char*			app_cover_image;
		char*			app_genre_name;
		int				app_installs;
		int				app_rating_count;
		int				app_rating_percent;
		int				is_ios;
		int				is_android;
		float			payout_usd;
		float			payout;
		int				currency_id;

		int64*			rr_offers;
		int				rr_offer_pos;
		int				rr_offer_max;

		Offer();
		virtual ~Offer();
		virtual void init(int max_region_id);
		virtual void set_region(uint region_id);
		virtual bool get_region(uint region_id);
		virtual void set_device(int device_id);
		virtual bool get_device(int device_id);
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();
};

class DefaultPricing: public Object {
	public:
		int64		id;
		float		min_price;
		float		max_price;
		float		percent;
		float		percent_cpa;
		int64		cpa_network_id;

		DefaultPricing();
		virtual ~DefaultPricing();
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();
};

class IncentSource: public Object {
	public:
		int64		id;
		char*		name;

		bool			do_free;

		IncentSource();
		virtual ~IncentSource();
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();
};

class Banner: public Object {
	public:
		int64			id;
		int64			offer_id;
		char*			logo_url;
		char*			image_url;
		char*			name;
		char*			description;
		int64			type_id;
		bool			do_free;

		Banner();
		virtual ~Banner();
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();
};

class Smartlink: public Object {
	public:
		int64			id;
		int64			user_id;
		int32			length;
		int64*			offers;
		int64*			ids;

		Smartlink();
		virtual ~Smartlink();
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();

};

class UserPostbacks: public Object {
	public:
		Hash *postbacks;//map<string, vector<string> >postbacks;
		int64 user_id;

		UserPostbacks();
		virtual ~UserPostbacks();
		virtual bool send(Tracker *tr);
		virtual bool send(Tracker *tr,Array *a);
		virtual bool load(ReadStream *s);
//		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual void add(const char *code,const char *url);
		virtual const char *classname();
};


class CpaNetworkEngine: public Object {
	public:
		int64 			id;
		char*			affre1;
		char*			affre2;
		char*			tracking_url_tail;
//		char*			tracking_url_cleanup_str;
//		pcre*			tracking_url_cleanup;
		bool			do_free;

		CpaNetworkEngine();
		virtual ~CpaNetworkEngine();
		virtual bool load(ReadStream *s);
		virtual bool load(PGresult *res,int row);
		virtual bool save(WriteStream *s);
		virtual const char *classname();
};

class OfferInfo: public Object {
	public:
		Offer *offer;
		CpaNetworkEngine *engine;
		int64 slo_id;

		OfferInfo(Offer *offer,CpaNetworkEngine *engine,int64 slo_id=0);
		virtual ~OfferInfo();

		virtual void dump(void);
		virtual const char *classname();
};

class Memcache: public Object {
	private:

	public:
		Memcache();
		virtual ~Memcache();
		
		virtual OfferInfo *get_offer(int64 offer_id,int region_id,int device_id,int affiliate_id);
		virtual float calc_payout_aff(float payout_db,float payout_db_usd);
		virtual bool load(char *ptr,int len);
		virtual bool load(PGconn *dbh);
		virtual void load__done();
		virtual void load__regions_start();
		virtual void load__regions_done();
		virtual void load__cpa_network_engines_start();
		virtual void load__cpa_network_engines_done();
		virtual void load__offers_start();
		virtual void load__offers_done();
		virtual void load__user_postbacks_start();
		virtual void load__user_postbacks_done();
		virtual void load__default_pricings_start();
		virtual void load__default_pricings_done();
		virtual void load__incent_sources_start();
		virtual void load__incent_sources_done();
		virtual void load__smartlinks_start();
		virtual void load__smartlinks_done();
		virtual void load__banners_start();
		virtual void load__banners_done();
		virtual bool save(WriteStream *s);
		virtual void cleanup();
		virtual int64 get_region(int64 i);
		virtual const char *classname();
	
		virtual bool db_done();

//		void (*_load_done_callback)(void);
		struct event    *_load_ev;

		static PGresult *pqexec_offers_list(int64 offer_id,PGconn*__dbh);

		PGconn *_dbh;
	
		IntHash *regions;
		IntHash *offers;
		IntHash *engines;
		IntHash *user_postbacks;
		IntHash *smartlinks;
		IntHash *banners;
		IntHash *incent_sources;
		Array *default_pricings;
		int min_smartlink_id;
		int max_region_id;
		char last_update[32];
/*
		map<int64,int64> regions;
		map<int64,Offer*> offers;
		map<int64,CpaNetworkEngine*> engines;
		map<int64,UserPostbacks*> user_postbacks;*/
		char *ptr_src;
};
#endif


