#ifndef OFFERMON_WRITER_H
#define OFFERMON_WRITER_H

#define MAX_CLUSTER_ITEMS		1024
#define DEFAULT_CLUSTER_ITEMS	128
#define DEFAULT_CLUSTERS_COUNT 4000
//#define DEFAULT_CLUSTERS_COUNT	40
#define DEFAULT_FILE_VERSION	1

#define FILE_HEADER 32
//#define CLUSTERS_COUNT 8000

#define AFF_SOURCE 1
#define AFF_SUB    2
#define AFF_SUB2   3
#define AFF_SUB3   4
#define AFF_SUB4   5
#define AFF_SUB5   6
#define AFF_PB     7
#define REFERER    8

#define WRITER_APPEND 1
#define WRITER_MODIFY 2
#define WRITER_READ 3

#define FLAG_GIF	1
#define FLAG_JS		2
#define FLAG_AJAX	4

#include "omatoms.h"

class Tracker;

void writers_init();
Writer *writer_get(int fileno);
void writers_stop();

class Writer {
	private:
		int cluster_pos;
		int maxpos;
		int64 cluster[MAX_CLUSTER_ITEMS];
		FILE *f;
		int nodeno;
		char filename[1024];
		int mode;
		int CLUSTER_ITEMS;// 128
		int CLUSTERS_COUNT;// 2
		int FILE_VERSION;

		char file_header[FILE_HEADER];
	public:
		int fileno;
		int version;

		Writer(int nodeno,int fileno,int _mode);
		~Writer();

		bool opened();

		void init();
		void file_create();
		void file_open();
		void file_close();
		void file_upgrade();

		void index_cluster_create(int _cl);
		void index_cluster_read(int _cl);
		void index_cluster_write();
		
		int64 get_offset_of(int pos);
		void set_offset_of(int pos,int64 offset);

		bool write_message(Tracker *m);
		void set_message_flag(Tracker *n);
		bool set_message_payout(Tracker *n);
		int get_maxpos();
		Tracker *read_message(int pos,Tracker *tr=NULL);
		Tracker *read_message_v0(int pos,Tracker *tr,int64 offset,int64 offset2,unsigned char *tmp);
		Tracker *read_message_v1(int pos,Tracker *tr,int64 offset,int64 offset2,unsigned char *tmp);
};
#endif
