#include <atoms/boolean.h>
#include <atoms/blob.h>

/*****************************************************************************/
Boolean::Boolean()
{
	value=false;
}

/*****************************************************************************/
Boolean::Boolean(bool a)
{
	value=a;
}

/*****************************************************************************/
Boolean::~Boolean()
{

}

/*****************************************************************************/
const char *Boolean::classname()
{
	return "Boolean";
}

/*****************************************************************************/
int8 Boolean::cmp(Object *c)
{
	Boolean *c1=dynamic_cast<Boolean*>(c);
	if (c1) {
		if (c1->value==value) return 0;
		return (value<c1->value)?-1:1;
	} else {
		return Object::cmp(c);
	}
}

/*****************************************************************************/
bool Boolean::storable_to_blob(Blob *b)
{
	b->add_bytes((const uint8*)(&value),1);
	b->word_align();
	return false;
}

/*****************************************************************************/

