#include <atoms/bytestream.h>

ByteStream::ByteStream()
{
	ptr=NULL;
	ptr_size=0;
}

ByteStream::~ByteStream()
{
	if (ptr) free(ptr);
}

void ByteStream::set_ptr_size(uint32 _size)
{
	if (_size&0x1fff) {
		_size-=_size&0x1fff;
		_size+=0x2000;
	}
	if (ptr_size>_size) return;
	if (ptr!=NULL) free(ptr);
	ptr_size=_size;
	ptr=(uint8*)malloc(ptr_size);
}

