#include <stdio.h>
#include <unistd.h>
#include <atoms/file.h>
#include <atoms/utf.h>
#include <ctype.h>

/*****************************************************************************/
File::File()
{
	filename=NULL;
	file=NULL;
}

/*****************************************************************************/
File::File(Text *_name)
{
	filename=_name;filename->add_ref();
	file=NULL;
}

/*****************************************************************************/
File::~File()
{
	close();
	if (filename) filename->del_ref();
}

/*****************************************************************************/
bool File::open (uint8 open_type)
{
	close();
	if (!filename) return false;
	Text8 *fn=dynamic_cast<Text8*>(filename); //fn non use.
	if (!fn) fn=new Text8(filename);
	fn->add_ref();
	bool res=true;
	switch (open_type) {
		case FILE_OPEN_RO:
			file=fopen(/*filename*/(char*)fn->text,"r");
			if (file) res=true;
			break;
		case FILE_OPEN_RW:
			file=fopen(/*filename*/(char*)fn->text,"rw");
			if (file) res=true;
			break;
		case FILE_OPEN_A:
			file=fopen(/*filename*/(char*)fn->text,"ra");
			if (file) res=true;
			break;
		default:
			break;
	}
	//fn->del_ref();
	return res;
}

/*****************************************************************************/
bool File::close()
{
	if (!file) return true;
	if (fclose(file)) return false;
	return true;
}

/*****************************************************************************/
void File::set_filename(Text *text)
{
	if (filename) filename->del_ref();
	filename=text;
	if (filename) filename->add_ref();
}

/*****************************************************************************/
char *File::read_file_to_ptr(uint64 &size)
{
	if (!open()) {
		size=0;
		return NULL;
	}
	size=file_size();
	char *c=(char*)malloc(sizeof(char)*size);
	fread(c,size,1,file);
	close();
	return c;
}

/*****************************************************************************/
Text8 *File::read_file_text8()
{
	uint64 size;
	char *c=read_file_to_ptr(size);
	Text8 *text=new Text8(c,size);
	free(c);
	return text;
}

/*****************************************************************************/
Text32 *File::read_file_text32()
{
	uint64 size;
	char *c=read_file_to_ptr(size);
	Text32 *text=new Text32(c,size);
	free(c);
	return text;
}

/*****************************************************************************/
Blob *File::read_file_blob()
{
	uint64 size;
	char *c=read_file_to_ptr(size);
	Blob *text=new Blob(c,size);
	free(c);
	return text;
}

/*****************************************************************************/
const char *File::classname()
{
	return "File";
}

/*****************************************************************************/
Text8 *File::read_string_text8(uint32 limiter)
{
	// Тут сложно.
	// 1. Создать char tmp[1000]
	// 2. Создать Text8 *result=NULL
	// 3. Читать туда по одному байту
	// 4. Если tmp заполнен, то
	// 4.1 Если result=NULL, result=new Text8(tmp,1000);
	// 4.2 Если result!=NULL, tmp2=new Text8(tmp,1000);tmp2->add_ref();result->add(tmp2);tmp2->del_ref();
	// 5. Проверять также нужно что найден символ. а вот это шляпа.
        // Каждые 4 байта сравнивать. Счётчик нужен.
	unsigned char tmp[1000];
	memset (tmp, 0, 1000);
	int i = 0;
	int symbegin = 0;
	bool cont = true;
	Text8* result = NULL;
	int c;
	while (cont)
	{
		c = getc(file);
		if (c == EOF) cont = false; 
		else tmp[i++] = c;
		if (issymbol((tmp + symbegin), i - symbegin))
		{
			if(comparesym (tmp + symbegin, i - symbegin, limiter))
			{
				cont = false;
				//break;
			}
			symbegin = i;
		}
		
		if (i == 1000 || !cont)
		{		
			//printf ("i=%d  symbegin=%d tmp = %s \n", i, symbegin, tmp); 
	 
			Text8* r = new Text8((char*)tmp, symbegin-1);
			if(r)
			{
				r -> add_ref();
				if (!result) result = r;
				else
				{ 
					result -> add(r);
					r -> del_ref();
				}
			}
		}
		
		if (i == 1000 && cont)
		{
			if (i - symbegin > 6 ) break;
			memcpy (tmp, tmp + symbegin, i-symbegin); //нераспознанный хвост пишем в нос
			memset (tmp + i - symbegin, 0, 1000 - i + symbegin);
			i = 0;
			symbegin = 0;
		}
			 
	}
	return result;
}

/*****************************************************************************/
Text32 *File::read_string_text32(uint32 limiter)
{
	assert(0);
}

/*****************************************************************************/
Blob *File::read_string_blob(uint32 limiter)
{
	assert(0);
}

/*****************************************************************************/
void File::save_file_text(Text *t)
{
	if (!file) open();
	seek(0,SEEK_SET);
	if (t) {
		fwrite(t->ptr(),1,t->size_in_bytes(),file);
		ftruncate(fileno(file),t->size_in_bytes());
	} else {
		ftruncate(fileno(file),0);
	}
	close();
}

/*****************************************************************************/
void File::save_string(Text *t)
{
	if (!file) return;
	if (!t) return;
	fwrite(t->ptr(),1,t->size_in_bytes(),file);
}

/*****************************************************************************/
uint64 File::file_size()
{
	if (!file) return 0;
	uint64 c=ftell(file);
	fseek(file,0,SEEK_END);
	uint64 c2=ftell(file);
	fseek(file,c,SEEK_SET);
	return c2;
}

/*****************************************************************************/
uint64 File::tell()
{
	if (!file) return 0;
	return ftell(file);
}

/*****************************************************************************/
void File::seek(uint64 ptr,uint8 type)
{
	if (!file) return;
	fseek(file,ptr,type);
}

/*****************************************************************************/
bool read_block(uint32 blocksize=8192)
{
	assert(0);
}

/****************************************************************************/
long long File :: atoll()
{
	char buf[30];
	memset (buf, 0, 30); 
	int c;
	bool first = true;
	int i = 0;
	while ((c = getc(file)) != EOF && i < 30)
	{
		if (isdigit(c))
		{
			buf [i] = c;
			i++;
		}	
		else if(first && (c == '-' || c == '+'))
		{
			buf [i] = c;
			i++;
		}
		else break;
	}	
	return ::atoll(buf);
}//atoll

void File :: putc (uint8 c, uint64 offset)
{
	if(!file) return;
	uint64 curr_ptr = fseek(file, 0, SEEK_CUR);
	fseek(file, offset, SEEK_SET);
	fputc(c, file);	
	fseek(file, curr_ptr, SEEK_SET);
}
