#include <stdio.h>
#include <atoms/inthash.h>

IntHash::IntHash()
{
	size=0;
	size_real=10;
	keys=(int64*)malloc(sizeof(int64)*size_real);
	values=(Object**)malloc(sizeof(Object*)*size_real);
}

IntHash::~IntHash()
{
	int i;
	for (i=0;i!=size;i++) {
		if (values[i]) values[i]->del_ref();
	}
	free(keys);
	free(values);
}

void IntHash::empty()
{
	int i;
	for (i=0;i!=size;i++) {
		if (values[i]) values[i]->del_ref();
	}
	size=0;
}

Object *IntHash::get(int64 k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (exist) return values[pos];
	return NULL;
}

void IntHash::put(int64 k,Object *v)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (exist) {
		if (values[pos]) values[pos]->del_ref();
		values[pos]=v;
		if (v) v->add_ref();
	} else {
		insert(pos,k,v);
	}
	
}

void IntHash::insert(int32 pos,int64 k,Object *v)
{
	int32 i;
	if (size_real==size) {
		int64 *keys2=keys;
		Object **values2=values;
		size_real=size_real*1.3+3;
		size_real>>=10;
		size_real++;
		size_real<<=10;
		keys=(int64*)malloc(sizeof(int64)*size_real);
		values=(Object**)malloc(sizeof(Object*)*size_real);
		memmove(keys,keys2,sizeof(int64)*size);
		for (i=0;i!=size;i++) {
			values[i]=values2[i];
		}
		free(values2);
		free(keys2);
	}
	for (i=size;i!=pos;i--) {
		keys[i]=keys[i-1];
		values[i]=values[i-1];
	}
	keys[pos]=k;
	values[pos]=v;
	if (v) v->add_ref();
	size++;
}

void IntHash::del(int64 k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (!exist) return;
	if (values[pos]) values[pos]->del_ref();
	size--;
	int32 i;
	for (i=pos;i!=size;i++) {
		keys[i]=keys[i+1];
		values[i]=values[i+1];
	}
}

bool IntHash::exist(int64 k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	return exist;
}

void IntHash::get_pos(int64 k,int32 &pos,bool &exist)
{
	int32 p1;
	int32 p2;
	if (size==0) {
		pos=0;
		exist=false;
		return;
	}
	if (size==1) {
		if (k==keys[0]) {
			exist=true;pos=0;
		} else {
			exist=false;
			pos=(k<keys[0])?0:1;
		}
		return;
	}
	p1=0;
	p2=size-1;
	if (k==keys[p1]) {
		exist=true;
		pos=p1;
		return;
	} else if (k<keys[p1]) {
		exist=false;
		pos=p1;
		return;
	}
	if (k>keys[p2]) {
		exist=false;
		pos=p2+1;
		return;
	} else if (k==keys[p2]) {
		exist=true;
		pos=p2;
		return;
	}
	while (p2-p1>1) {
		int32 c=(p2+p1)>>1;
//		printf("keys[%d]=%d keys[%d]=%d keys[%d]=%d\n",p1,keys[p1],c,keys[c],p2,keys[p2]);
		if (k==keys[c]) {
			pos=c;
			exist=true;
			return;
		} else if (k>keys[c]) {
			p1=c;
		} else if (k<keys[c]) {
			p2=c;
		}
	}
	exist=false;
	pos=p2;
}

const char *IntHash::classname()
{
	return "IntHash";
}

Array *IntHash::get_keys()
{
	Array *r=new Array();
	r->grow(size);
	uint32 i;
	for (i=0;i!=size;i++) {
		r->put(i,new Int64(keys[i]));
	}
	return r;
}

Array *IntHash::get_values()
{
	Array *r=new Array();
	r->grow(size);
	uint32 i;
	for (i=0;i!=size;i++) {
		r->put(i,values[i]);
	}
	return r;
}


void IntHash::print_keys()
{
	uint32 i;
	printf("IntHash::print_keys():\n");
	for (i=0;i!=size;i++) {
		printf("%d [%d]=%xh\n",i,keys[i],values[i]);
	}
}

