#include <stdio.h>
#include <time.h>
#include <sys/select.h>
#include <atoms/array.h>
#include <atoms/select.h>

/*****************************************************************************/
Select::Select()
{
	sockets=new Array();
	sockets->add_ref();
}

/*****************************************************************************/
Select::~Select()
{
	sockets->del_ref();
}

/*****************************************************************************/
const char *Select::classname()
{
	return "Select";
}

/*****************************************************************************/
void Select::add(Socket *s)
{
	sockets->push(s);
}

/*****************************************************************************/
void Select::del(Socket *s)
{
	sockets->del(s);
}

/*****************************************************************************/
Array *Select::can_read(double timeout)
{
	fd_set set;
	FD_ZERO(&set);
	uint32 i=0;
	uint32 max=0;
	uint32 cnt=0;
	for (i=0;i!=sockets->size;i++) {
		Socket *s=dynamic_cast<Socket*>(sockets->array[i]);
		if (!s) continue;
		int fd=s->get_fd();
		if (fd<0) continue;
		FD_SET(fd,&set);
		if (max<fd) max=fd;
		cnt++;
	}
	struct timeval tv;
	tv.tv_sec=timeout;
	tv.tv_usec=(timeout-tv.tv_sec)*1000000;
	if (cnt==0) {
		struct timespec tv2;
		tv2.tv_sec=timeout;
		tv2.tv_nsec=(timeout-tv2.tv_sec)*1000000;
		nanosleep(&tv2,NULL);
		return NULL;
	}
	int ready=select(max+1,&set,NULL,NULL,&tv);
	
	if (ready<=0) return NULL;

	Array *r=new Array();
	for (i=0;i!=sockets->size;i++) {
		Socket *s=dynamic_cast<Socket*>(sockets->array[i]);
		if (!s) continue;
		if (s->get_fd()<0) continue;
		if (FD_ISSET(s->get_fd(),&set)) r->push(s);
	}
	return r;
}

/*****************************************************************************/

