#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <atoms/socket_tcp.h>

/*****************************************************************************/
SocketTcp::SocketTcp()
{
	addrlen=sizeof(addr);
}

/*****************************************************************************/
SocketTcp::~SocketTcp()
{
	close();
}

/*****************************************************************************/
const char *SocketTcp::classname()
{
	return "SocketTcp";
}

/*****************************************************************************/
bool SocketTcp::connect(const char *hostname,uint16 port)
{
	if (fd!=-1) close();
	struct hostent *hp;
	hp = gethostbyname(hostname);
	if (hp==NULL) {
		return false;
	}

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr=((struct in_addr*)(hp->h_addr))->s_addr;
	addr.sin_port=htons(port);

	fd=socket(AF_INET, SOCK_STREAM, 0);
	if (fd==-1) {
		return false;
	}

	if (::connect(fd,(struct sockaddr*)&addr,sizeof(addr))==-1) {
		close();
		return false;
	}
	return true;
}

/*****************************************************************************/
bool SocketTcp::listen(const char *hostname,uint16 port,uint16 queue_size)
{
	if (fd!=-1) close();
	fd=socket(AF_INET, SOCK_STREAM,0);
	if (fd==-1) return false;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	if (hostname==NULL) {
		addr.sin_addr.s_addr = INADDR_ANY;
	} else {
		assert(0);
	}
	addr.sin_port = htons(port);

	if (bind(fd,(struct sockaddr*)&addr,sizeof(addr))==-1) {
		close();
		return false;
	}
	if (::listen(fd,queue_size)==-1) {
		close();
		return false;
	}
	return true;
}

/*****************************************************************************/
void SocketTcp::close(void)
{
	if (fd!=-1) ::close(fd);
	Socket::close();
//fd=-1;
}

/*****************************************************************************/
Socket *SocketTcp::accept()
{
	SocketTcp *sock=new SocketTcp();
	sock->fd=::accept(fd,(struct sockaddr*)&sock->addr,&sock->addrlen);
	if (sock->fd==-1) {
		delete sock;
		return NULL;
	}
	return sock;
}

/*****************************************************************************/

