#include <time.h>

#include "offermon/scan_struct.h"

#include "offermon/tracker_static.h"
#include "offermon/tracker.h"
#include "offermon/writer.h"


const char *default_scan_columns="clickid,click_date,offer_id,user_id,region_id,device_id,ip,payout_date,payout_db,payout_db_usd,payout_db_aff,currency_db_id,payout_http,foreign_clickid,aff_source";
/*
clickid
click_date
offer_id
user_id
ip
region_id
checks
user_agent_id
device_id
smartlink_offer_id
foreign_clickid
aff_source
aff_sub
aff_sub2
aff_sub3
aff_sub4
aff_sub5
aff_pb
gif_rnd
js_user_agent_id
js_width
js_height
payout_date
payout
payout_db
payout_db_usd
payout_db_aff
currency_db_id
payout_http
payout_ip
*/
StatItemStruct::StatItemStruct()
{
	clicks			=0;
	fail_gif		=0;
	fail_js			=0;
	fail_js2		=0;
	fail_any		=0;
	clicks_checked	=0;
	installs		=0;
	payout_db		=0;
	payout_db_usd	=0;
	payout_db_aff	=0;
	currency_db_id	=0;
	payout_http		=0;
}

StatItemStruct::~StatItemStruct()
{

}

void StatItemStruct::init(Tracker *tr)
{
/*	click_date	=tr->click_date;
	offer_id	=tr->offer_id;
	user_id		=tr->user_id;
	device_id	=tr->device_id;
	region_id	=tr->region_id;*/
}

void StatItemStruct::add(Tracker *tr)
{
	clicks++;
	if (tr->payout_date) {
		installs++;
		payout_db		+=tr->payout_db;
		payout_db_usd	+=tr->payout_db_usd;
		payout_db_aff	+=tr->payout_db_aff;
		payout_http		+=tr->payout_http;
	}
	currency_db_id	 =tr->currency_db_id;
	if (tr->checks&5) clicks_checked++;
	if ((tr->checks&5)!=5) fail_any++;
	if (!(tr->checks&1)) fail_gif++;
	if (!(tr->checks&4)) {
		fail_js++;
	} else {
		if (tr->user_agent_id!=tr->js_user_agent_id) { // TODO resolution checks
			fail_js2++;
		}
	}
}

void StatItemStruct::dump(const char *headers)
{
/*	char d[128];
	struct tm *p;
	time_t t;

	t=click_date;
   	p = localtime(&t);
	strftime(d,128, "%Y-%m-%d", p);
	printf("%s	%d	%d	%d	%d	%d	%d	%f	%f	%f	%d	%f	%d	%d	%d	%d\n",d,offer_id,user_id,device_id,region_id,clicks,installs,payout_db,payout_db_usd,payout_db_aff,currency_db_id,payout_http,clicks_checked,fail_gif,fail_js,fail_js2);*/
	printf("%s%d	%d	%f	%f	%f	%d	%f	%d	%d	%d	%d	%d\n",headers,clicks,installs,payout_db,payout_db_usd,payout_db_aff,currency_db_id,payout_http,clicks_checked,fail_gif,fail_js,fail_js2,fail_any);

}

const char *StatItemStruct::classname() { return "StatItemStruct"; }



ScanStruct::ScanStruct()
{
	stats=NULL;
}

ScanStruct::~ScanStruct()
{
	if (stats) stats->del_ref();
}
void ScanStruct::stats_init()
{
	stats=new Hash();
}

void ScanStruct::stats_add(Tracker *tr)
{
	BlobPtr *b;
	StatItemStruct *sis;
	char *key=tmp;
/*	struct tm *p;
	time_t t;

	t=tr->click_date;
   	p = localtime(&t);
	strftime(d,128, "%Y-%m-%d", p);
	sprintf(key,"%s/%ld/%d/%d/%d",d,tr->offer_id,tr->user_id,tr->device_id,tr->region_id);
	*/
	print_scan(tr);

	b=new BlobPtr(key,strlen(key)+1);
	sis=dynamic_cast<StatItemStruct*>(stats->get(b));
	if (!sis) {
//		printf("ADD key=%s  len=%d, hash size=%d\n",key,strlen(key),stats->size);
		sis=new StatItemStruct();
		sis->init(tr);
		stats->put(new Blob(key,strlen(key)+1),sis);
	} else {
//		printf("UPD key=%s  len=%d, hash size=%d\n",key,strlen(key),stats->size);
//		printf("\"%s\" vs \"%s\" len=%d\n",dynamic_cast<Blob*>(stats->keys[0])->text,key,dynamic_cast<Blob*>(stats->keys[0])->length);
	}
	delete b;
	sis->add(tr);
}

void ScanStruct::stats_dump()
{
	int i;
	StatItemStruct *sis;
	Blob *blb;

	print_headers();
	printf("clicks	installs	payout_db	payout_db_usd	payout_db_aff	currency_db_id	payout_http	clicks_checked	fail_gif	fail_js	fail_js2	fail_any\n");
	//printf("date_cr	offer_id	user_id	device_id	region_id	clicks	installs	payout_db	payout_db_usd	payout_db_aff	currency_db_id	payout_http	clicks_checked	fail_gif	fail_js	fail_js2\n");
	for (i=0;i<stats->size;i++) {
		sis=dynamic_cast<StatItemStruct*>(stats->values[i]);
		blb=dynamic_cast<Blob*>(stats->keys[i]);
//		if (!blb) fprintf(stderr,"blb==NULL!");
		sis->dump((const char*)(blb->text));
	}
}

void ScanStruct::columns_init(const char*_cols)
{
	char cols[4000];
	if (_cols==NULL) _cols=default_scan_columns;
	sprintf(cols,",%s,",_cols);
	show_clickid			=0;
	show_click_date			=0;
	show_click_dateonly		=0;
	show_offer_id			=0;
	show_user_id			=0;
	show_ip					=0;
	show_region_id			=0;
	show_checks				=0;
	show_user_agent_id		=0;
	show_device_id			=0;
	show_smartlink_offer_id	=0;
	show_foreign_clickid	=0;
	show_aff_source			=0;
	show_aff_sub			=0;
	show_aff_sub2			=0;
	show_aff_sub3			=0;
	show_aff_sub4			=0;
	show_aff_sub5			=0;
	show_aff_pb				=0;
	show_gif_rnd			=0;
	show_js_user_agent_id	=0;
	show_js_width			=0;
	show_js_height			=0;
	show_payout_date		=0;
	show_payout_db			=0;
	show_payout_db_usd		=0;
	show_payout_db_aff		=0;
	show_currency_db_id		=0;
	show_payout_http		=0;
	show_payout_ip			=0;
	show_referer			=0;

	if (strstr(cols,",clickid,")			!=NULL) show_clickid			=1;
	if (strstr(cols,",click_date,")			!=NULL) show_click_date			=1;
	if (strstr(cols,",click_dateonly,")		!=NULL) show_click_dateonly		=1;
	if (strstr(cols,",offer_id,")			!=NULL) show_offer_id			=1;
	if (strstr(cols,",user_id,")			!=NULL) show_user_id			=1;
	if (strstr(cols,",ip,")					!=NULL) show_ip					=1;
	if (strstr(cols,",region_id,")			!=NULL) show_region_id			=1;
	if (strstr(cols,",checks,")				!=NULL) show_checks				=1;
	if (strstr(cols,",user_agent_id,")		!=NULL) show_user_agent_id		=1;
	if (strstr(cols,",device_id,")			!=NULL) show_device_id			=1;
	if (strstr(cols,",smartlink_offer_id,")	!=NULL) show_smartlink_offer_id	=1;
	if (strstr(cols,",foreign_clickid,")	!=NULL) show_foreign_clickid	=1;
	if (strstr(cols,",aff_source,")			!=NULL) show_aff_source			=1;
	if (strstr(cols,",aff_sub,")			!=NULL) show_aff_sub			=1;
	if (strstr(cols,",aff_sub2,")			!=NULL) show_aff_sub2			=1;
	if (strstr(cols,",aff_sub3,")			!=NULL) show_aff_sub3			=1;
	if (strstr(cols,",aff_sub4,")			!=NULL) show_aff_sub4			=1;
	if (strstr(cols,",aff_sub5,")			!=NULL) show_aff_sub5			=1;
	if (strstr(cols,",aff_pb,")				!=NULL) show_aff_pb				=1;
	if (strstr(cols,",gif_rnd,")			!=NULL) show_gif_rnd			=1;
	if (strstr(cols,",js_user_agent_id,")	!=NULL) show_js_user_agent_id	=1;
	if (strstr(cols,",js_width,")			!=NULL) show_js_width			=1;
	if (strstr(cols,",js_height,")			!=NULL) show_js_height			=1;
	if (strstr(cols,",payout_date,")		!=NULL) show_payout_date		=1;
	if (strstr(cols,",payout_db,")			!=NULL) show_payout_db			=1;
	if (strstr(cols,",payout_db_usd,")		!=NULL) show_payout_db_usd		=1;
	if (strstr(cols,",payout_db_aff,")		!=NULL) show_payout_db_aff		=1;
	if (strstr(cols,",currency_db_id,")		!=NULL) show_currency_db_id		=1;
	if (strstr(cols,",payout_http,")		!=NULL) show_payout_http		=1;
	if (strstr(cols,",payout_ip,")			!=NULL) show_payout_ip			=1;
	if (strstr(cols,",referer,")			!=NULL) show_referer			=1;
}

void ScanStruct::print_headers()
{
	if (show_clickid			) printf("clickid\t");
	if (show_click_date			) printf("click_date\t");
	if (show_click_dateonly		) printf("click_dateonly\t");
	if (show_offer_id			) printf("offer_id\t");
	if (show_user_id			) printf("user_id\t");
	if (show_ip					) printf("ip\t");
	if (show_region_id			) printf("region_id\t");
	if (show_checks				) printf("checks\t");
	if (show_user_agent_id		) printf("user_agent_id\t");
	if (show_device_id			) printf("device_id\t");
	if (show_smartlink_offer_id	) printf("smartlink_offer_id\t");
	if (show_foreign_clickid	) printf("foreign_clickid\t");
	if (show_aff_source			) printf("aff_source\t");
	if (show_aff_sub			) printf("aff_sub\t");
	if (show_aff_sub2			) printf("aff_sub2\t");
	if (show_aff_sub3			) printf("aff_sub3\t");
	if (show_aff_sub4			) printf("aff_sub4\t");
	if (show_aff_sub5			) printf("aff_sub5\t");
	if (show_aff_pb				) printf("aff_pb\t");
	if (show_gif_rnd			) printf("gif_rnd\t");
	if (show_js_user_agent_id	) printf("js_user_agent_id\t");
	if (show_js_width			) printf("js_width\t");
	if (show_js_height			) printf("js_height\t");
	if (show_payout_date		) printf("payout_date\t");
	if (show_payout_db			) printf("payout_db\t");
	if (show_payout_db_usd		) printf("payout_db_usd\t");
	if (show_payout_db_aff		) printf("payout_db_aff\t");
	if (show_currency_db_id		) printf("currency_db_id\t");
	if (show_payout_http		) printf("payout_http\t");
	if (show_payout_ip			) printf("payout_ip\t");
	if (show_referer			) printf("referer\t");
}

void ScanStruct::print_scan(Tracker *tr)
{
//	if (tr->click_date) click_date_str=ctime((const time_t*)&tr->click_date);
//	if (tr->payout_date) payout_date_str=ctime((const time_t*)&tr->payout_date);

	int pos=0;
	int MAXSIZE=65535;
	if (show_clickid			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d_%d_%d	",tr->clickid_entryno,tr->clickid_fileno,tr->clickid_nodeno);
	if (show_click_date			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",click_date_str);
	if (show_click_dateonly		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",click_dateonly_str);
	if (show_offer_id			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->offer_id);
	if (show_user_id			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->user_id);
	if (show_ip					) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",ip_str);
	if (show_region_id			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d	",tr->region_id);
	if (show_checks				) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d	",tr->checks);
	if (show_user_agent_id		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->user_agent_id);
	if (show_device_id			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->device_id);
	if (show_smartlink_offer_id	) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->smartlink_offer_id);
	if (show_foreign_clickid	) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->foreign_clickid);
	if (show_aff_source			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_source);
	if (show_aff_sub			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_sub);
	if (show_aff_sub2			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_sub2);
	if (show_aff_sub3			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_sub3);
	if (show_aff_sub4			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_sub4);
	if (show_aff_sub5			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_sub5);
	if (show_aff_pb				) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->aff_pb);
	if (show_gif_rnd			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d	",tr->gif_rnd);
	if (show_js_user_agent_id	) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%ld	",tr->js_user_agent_id);
	if (show_js_width			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d	",tr->js_width);
	if (show_js_height			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%d	",tr->js_height);
	if (show_payout_date		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",payout_date_str);
	if (show_payout_db			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%f	",tr->payout_db);
	if (show_payout_db_usd		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%f	",tr->payout_db_usd);
	if (show_payout_db_aff		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%f	",tr->payout_db_aff);
	if (show_currency_db_id		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%f	",tr->currency_db_id);
	if (show_payout_http		) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%f	",tr->payout_http);
	if (show_payout_ip			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",payout_ip_str);
	if (show_referer			) pos+=snprintf(tmp+pos,MAXSIZE-pos,"%s	",tr->referer);
	tmp[pos]=0;
}

const char *ScanStruct::classname() { return "ScanStruct"; }







/**
 * Function: scanner
 */
void scanner(int fileno,ScanStruct *ss,void (*on_each_row)(int,Tracker *,ScanStruct *))
{
	TrackerStatic *ts=new TrackerStatic();
	Writer *w=new Writer(NODENO,fileno,WRITER_READ);
	if (!w->opened()) {
		delete w;
		exit(1);
	}
	Tracker *tr;//=new Tracker(ts);
	int pos=0;
	struct tm *p;
	time_t t;
	while ( (tr=w->read_message(pos,NULL))!=NULL ) {
		switch (tr->ip[0]) {
			case 1: inet_ntop(AF_INET ,tr->ip+4,ss->ip_str,124); break;
			case 2: inet_ntop(AF_INET6,tr->ip+4,ss->ip_str,124); break;
			default: strcpy(ss->ip_str,"NULL"); break;
		}
		switch (tr->payout_ip[0]) {
			case 1: inet_ntop(AF_INET ,tr->payout_ip+4,ss->payout_ip_str,124); break;
			case 2: inet_ntop(AF_INET6,tr->payout_ip+4,ss->payout_ip_str,124); break;
			default: strcpy(ss->payout_ip_str,"NULL"); break;
		}

		t=tr->click_date;
   		p = localtime(&t);
		strftime(ss->click_date_str,128, "%Y-%m-%d %H:%M:%S", p);
		strftime(ss->click_dateonly_str,128, "%Y-%m-%d", p);
   		if (tr->payout_date) {
			t=tr->payout_date;
			p = localtime(&t);
			strftime(ss->payout_date_str,128, "%Y-%m-%d %H:%M:%S", p);
		} else {
			sprintf(ss->payout_date_str,"NULL");
		}
		on_each_row(pos,tr,ss);
//		tr->dump();exit(0);
		pos++;
		delete tr;
	}
	delete w;
	delete ts;
}

/**
 * Function: file_scan_on_each_row
 */
void file_scan_on_each_row(int pos,Tracker *tr,ScanStruct *ss)
{
	ss->print_scan(tr);
	printf("%s\n",ss->tmp);
}

/**
 * Function: file_stat_on_each_row
 */
void file_stat_on_each_row(int pos,Tracker *tr,ScanStruct *ss)
{
	ss->stats_add(tr);
}


