
#include "offermon/streams.h"

const char *EMPTY="";
ReadStream::ReadStream(unsigned char*ptr,int32 ptr_len)
{
	this->src_ptr=ptr;
	this->ptr=ptr;
	this->ptr_len=ptr_len;
}

ReadStream::~ReadStream()
{
	
}


int64 ReadStream::read_int64()
{
	int64 r;
/*	r =(ptr)[7];r<<=8;
	r+=(ptr)[6];r<<=8;
	r+=(ptr)[5];r<<=8;
	r+=(ptr)[4];r<<=8;
	r+=(ptr)[3];r<<=8;
	r+=(ptr)[2];r<<=8;
	r+=(ptr)[1];r<<=8;
	r+=(ptr)[0];*/
	r=((int64*)ptr)[0];
	ptr+=8;
	return r;

}

int32 ReadStream::read_int32()
{
	int32 r;
	r=((int32*)ptr)[0];
/*	r =(ptr)[3];r<<=8;
	r+=(ptr)[2];r<<=8;
	r+=(ptr)[1];r<<=8;
	r+=(ptr)[0];*/
	ptr+=4;
	return r;
}

void ReadStream::read_ip(char *ip)
{
	memmove(ip,ptr,12);
	ptr+=12;
}


char*ReadStream::read_charptr()
{
	char *r=(char*)ptr;
	while (ptr[0]!=0) ptr++;
	ptr++;
	while ( ((int64)ptr) & ((int64)3)) ptr++;
	return r;
}

/**
 * Method: ReadStream::set
 */
void ReadStream::set(int32 a)
{
	ptr=src_ptr+a;
	while ( ((int64)ptr) & ((int64)3)) ptr++;
}

/**
 * Method: ReadStream::get
 */
int32 ReadStream::get(void)
{
	return ptr-src_ptr;
}

/**
 * Method: ReadStream::len
 */
int32 ReadStream::len(void)
{
	return ptr_len;
}

const char *ReadStream::classname() { return "ReadStream"; }


/**
 * Method: WriteStream::new
 */
WriteStream::WriteStream()
{
	out=NULL;
	ptr=src_ptr=NULL;
	ptr_len=0;
	do_free=true;
}

/**
 * Method: WriteStream::new
 */
WriteStream::WriteStream(unsigned char *_ptr,int _len)
{
	out=NULL;
	do_free=false;
	src_ptr=ptr=_ptr;
	ptr_len=_len;
}

/**
 * Method: WriteStream::delete
 */
WriteStream::~WriteStream()
{
	if (out) fclose(out);
	if (do_free && src_ptr) free(src_ptr);
}

/**
 * Method: WriteStream::file_open
 */
void WriteStream::file_open(const char *filename)
{
	out=NULL;
	ptr=src_ptr=NULL;
	ptr_len=0;
	do_free=true;
	out=fopen(filename,"w");
	if (!out) {
		fprintf(stderr,"WriteStream::file_open(%s) - error",filename);
		exit(1);
	}
}

/**
 * Method: WriteStream::grow
 */
void WriteStream::grow(int amnt)
{
	unsigned char *old_src_ptr=src_ptr;
	int old_len=ptr_len;
	int offset=ptr-src_ptr;

	ptr_len+=amnt;
	src_ptr=(unsigned char*)malloc(ptr_len);
	if (old_src_ptr) {
		memmove(src_ptr,old_src_ptr,old_len);
		if (do_free) {
			free(old_src_ptr);
		} else {
			do_free=false;
		}
	}
	ptr=src_ptr+offset;
}

/**
 * Method: WriteStream::check_grow
 */
void WriteStream::check_grow(int a)
{
	int used=ptr-src_ptr;
	int need=used+a;
	if (need>=ptr_len) {
		int32 amnt=need+512;
		if (amnt<1024) amnt+=1024;
		grow(amnt);
	}
}

/**
 * Method: WriteStream::write_int32
 */
void WriteStream::write_int32(int32 i)
{
	if (out) {
		fwrite((char*)&i,1,4,out);
		return;
	}
	check_grow(4);
	/*
	ptr[0]=i&255;
	ptr[1]=(i>>8)&255;
	ptr[2]=(i>>16)&255;
	ptr[3]=(i>>24)&255;*/
	((int32*)ptr)[0]=i;
	ptr+=4;
}

/**
 * Method: WriteStream::write_int64
 */
void WriteStream::write_int64(int64 i)
{
	if (out) {
		fwrite((char*)&i,1,8,out);
		return;
	}
	check_grow(8);
	((int64*)ptr)[0]=i;
	/*
	ptr[0]=i&255;
	ptr[1]=(i>>8)&255;
	ptr[2]=(i>>16)&255;
	ptr[3]=(i>>24)&255;
	ptr[4]=(i>>32)&255;
	ptr[5]=(i>>40)&255;
	ptr[6]=(i>>48)&255;
	ptr[7]=(i>>56)&255;*/
	ptr+=8;
}

/**
 * Method: WriteStream::write_charptr
 */
void WriteStream::write_charptr(const char *a)
{
	char tmp[4]={0,0,0,0};
	if (a==NULL) a=EMPTY;
	if (out) {
		fwrite(a,1,strlen(a)+1,out);
		while (ftell(out)&3) fwrite(tmp,1,1,out);
		return;
	}
	int l=strlen(a);
	check_grow(l+1);
	memmove(ptr,a,l+1);
	ptr+=l+1;
	while ( ((int64)ptr) & ((int64)3)) ptr++;
}

/**
 * Method: WriteStream::write_ip
 */
void WriteStream::write_ip(char *ip)
{
	if (out) {
		fwrite(ip,1,12,out);
		return;
	}
	check_grow(13);
	memmove(ptr,ip,12);
	ptr+=12;
}


/**
 * Method: WriteStream::len
 */
int32 WriteStream::len()
{
	return ptr-src_ptr;
}

/**
 * Method: WriteStream::set
 */
void WriteStream::set(int32 a)
{
	ptr=src_ptr+a;
}

/**
 * Method: WriteStream::get
 */
int32 WriteStream::get(void)
{
	return ptr-src_ptr;
}


int64 WriteStream::read_int64()
{
	int64 r;
	r=((int64*)ptr)[0];
	ptr+=8;
	return r;

}

int32 WriteStream::read_int32()
{
	int32 r;
	r=((int32*)ptr)[0];
	ptr+=4;
	return r;
}

const char *WriteStream::classname() { return "WriteStream"; }


