#include <stdio.h>
#include <stdlib.h>
#include <memory>
//#include <cstdint>
#include <iostream>
#include <arpa/inet.h>

#include "offermon/tracker_static.h"
#include "offermon/tracker.h"
#include "offermon/memcache.h"
#include "offermon/writer.h"
#include "offermon/template_file.h"

#define DEBUG 0

const char *ct_html="text/html; charset=utf-8";
const char *ct_gif="image/gif";
const char *ct_js="application/javascript";

  long atol0(const char *nptr) { if (nptr==NULL) return 0; return atol(nptr); }
   int atoi0(const char *nptr) { if (nptr==NULL) return 0; return atoi(nptr); }
double atof0(const char *nptr) { if (nptr==NULL) return 0; return atof(nptr); }
/**
 * Function: reject
 */
void reject(const char *fmt,...)
{
	struct timeval tv;
	struct timezone tz;
	gettimeofday(&tv,&tz);

	FILE *tmp=fopen("/www/combine-erp/SITES/offermon/tracker-datafiles/rejects.log","a");
	fprintf(tmp,"time=%d | ",tv.tv_sec);

	va_list(args);
	va_start(args, fmt);
	vfprintf(tmp,fmt,args);
	va_end(args);

	fprintf(tmp,"\n");
	fclose(tmp);

}

/**
 * Method: Tracker::new
 */
Tracker::Tracker()
{
}

/**
 * Method: Tracker::delete
 */
Tracker::~Tracker()
{
	if (evb) evbuffer_free(evb);
	if (free_on_delete) free(free_on_delete);
	ois_preselected_free();
}

/**
 * Method: Tracker::init
 */
void Tracker::init()
{
	ois_preselected_pos=0;
	ois_preselected=NULL;
	evb=NULL;
	free_on_delete=NULL;
	clickid_str=js_ua=ip_str=ua=NULL;
	foreign_clickid=NULL;
	referer=aff_pb=aff_source=aff_sub=aff_sub2=aff_sub3=aff_sub4=aff_sub5=NULL;

	js_user_agent_id=payout_user_agent_id=0;
	
	js_height=js_width=0;
	checks			=0;
	payout_date		=0;
	ignore_device	=false;
	ignore_region	=false;
	memset(ip,0,12);
	memset(payout_ip,0,12);
	content_type=NULL;
	smartlink_id=0;
}


/**
 * Method: Tracker::init
 */
void Tracker::init(evhttp_request *_req)
{
	init();
	const char *uri;
	struct evkeyvalq headers;

	req=_req;
	evb = evbuffer_new();

	evhttp_parse_query (evhttp_request_get_uri (req), &headers);
	
//	const char *q = evhttp_find_header (&headers, "q");

	// defaults:
	checks=0;

	mode=0;
	uri					=req->uri;

//	printf("URI=%s\n",uri);
	if (strncmp(uri,"/offer/",7)==0) {
		mode=MODE_INDEX;
	} else if (strncmp(uri,"/gif/",5)==0) {
		mode=MODE_GIF;
	} else if (strncmp(uri,"/js/",4)==0) {
		mode=MODE_JS;
	} else if (strncmp(uri,"/ajax/",6)==0) {
		mode=MODE_AJAX;
	} else if (strncmp(uri,"/postback/",10)==0) {
		mode=MODE_POSTBACK;
	} else if (strncmp(uri,"/quit/",6)==0) {
		mode=MODE_SYSTEM;
		quit=1;
	} else if (strncmp(uri,"/refresh/",9)==0) {
		ts_needs_update=1;
		mode=MODE_SYSTEM;
	} else if (strncmp(uri,"/offerwall/",11)==0) {
		mode=MODE_OFFERWALL;
	} else if (strncmp(uri,"/smartpopup/",12)==0) {
		mode=MODE_SMARTPOPUP;
	} else if (strncmp(uri,"/smartoffer/",12)==0) {
		mode=MODE_SMARTOFFER;
	}

	ip_str				=req->remote_host;
	if (!ip_str) return;
	if (strcmp(ip_str,"127.0.0.1")==0) {
		const char *ip_str_tmp=evhttp_find_header(req->input_headers, "X-Forwarded-For");
		if (ip_str_tmp) ip_str=ip_str_tmp;
	}
	ua					=evhttp_find_header(req->input_headers, "User-Agent");
	referer				=evhttp_find_header(req->input_headers, "Referer");
	if (!ua) ua="-null-";
	foreign_clickid		=evhttp_find_header(&headers,"clickid");
	if (!foreign_clickid) foreign_clickid		=evhttp_find_header(&headers,"click_id");
//	offer_id			=atol0(evhttp_find_header(&headers,"offer_id"));
//	user_id				=atol0(evhttp_find_header(&headers,"aff_id"));
//	smartlink_id		=atol0(evhttp_find_header(&headers,"sl_id"));
	smartlink_offer_id	=atol0(evhttp_find_header(&headers,"slo_id"));
	aff_source			=evhttp_find_header(&headers,"source");
	aff_sub				=evhttp_find_header(&headers,"aff_sub");
	aff_sub2			=evhttp_find_header(&headers,"aff_sub2");
	aff_sub3			=evhttp_find_header(&headers,"aff_sub3");
	aff_sub4			=evhttp_find_header(&headers,"aff_sub4");
	aff_sub5			=evhttp_find_header(&headers,"aff_sub5");
	aff_pb				=evhttp_find_header(&headers,"pb");
	js_ua				=evhttp_find_header(&headers,"js_ua");
	js_width			=atol0(evhttp_find_header(&headers,"js_width"));
	js_height			=atol0(evhttp_find_header(&headers,"js_height"));
	payout_http			=atof0(evhttp_find_header(&headers,"payout"));
	force_device_id		=atol0(evhttp_find_header(&headers,"device_id"));
	force_region_id		=atol0(evhttp_find_header(&headers,"region_id"));
	ignore_device		=atoi0(evhttp_find_header(&headers,"ignore_device"))?true:false;
	ignore_region		=atoi0(evhttp_find_header(&headers,"ignore_region"))?true:false;

	offer_id=0;
	user_id=0;
	switch (mode) {
		case MODE_INDEX:
			sscanf(uri,"/offer/%d/%d/",&offer_id,&user_id);
			break;

		case MODE_GIF:
			clickid_entryno=clickid_fileno=clickid_nodeno=0;
			sscanf(uri,"/gif/%d_%d_%d/%d.gif",&clickid_entryno,&clickid_fileno,&clickid_nodeno,&gif_rnd);
			break;

		case MODE_OFFERWALL:
			smartlink_id=0;
			if (sscanf(uri,"/offerwall/%d/%d/",&smartlink_id,&user_id)==2) {
			} else if (sscanf(uri,"/offerwall/%d/",&smartlink_id)==1) {
				user_id=0;
			} else {
				smartlink_id=0;
				user_id=0;
			}
			break;

		case MODE_SMARTOFFER:
			smartlink_id=0;
			if (sscanf(uri,"/smartoffer/%d/%d/",&smartlink_id,&user_id)==2) {
			} else if (sscanf(uri,"/smartoffer/%d/",&smartlink_id)==1) {
				user_id=0;
			} else {
				smartlink_id=0;
				user_id=0;
			}
			break;
		
		case MODE_SMARTPOPUP:
			smartlink_id=0;
			if (sscanf(uri,"/smartpopup/%d/%d/",&smartlink_id,&user_id)==2) {
			} else if (sscanf(uri,"/smartpopup/%d/",&smartlink_id)==1) {
				user_id=0;
			} else {
				smartlink_id=0;
				user_id=0;
			}
			break;
		
		case MODE_JS:
			clickid_entryno=clickid_fileno=clickid_nodeno=0;
			sscanf(uri,"/js/%d_%d_%d.js",&clickid_entryno,&clickid_fileno,&clickid_nodeno,&gif_rnd);
			break;

		case MODE_AJAX:
			clickid_entryno=clickid_fileno=clickid_nodeno=0;
			sscanf(uri,"/ajax/%d_%d_%d.cgi",&clickid_entryno,&clickid_fileno,&clickid_nodeno,&gif_rnd);
//			clickid_str			=evhttp_find_header(&headers,"omclickid");
			break;

		case MODE_POSTBACK:
			clickid_str			=evhttp_find_header(&headers,"click_id");
			break;
	}

	if (strstr(ip_str,":")==NULL) {
		this->ip[0]=1;
		inet_pton(AF_INET,ip_str,this->ip+4);
	} else {
		this->ip[0]=2;
		inet_pton(AF_INET6,ip_str,this->ip+4);
	}
}

/**
 * Method: Tracker::init
 */
void Tracker::init(int32 mode,const char*ip,const char*ua,int64 offer_id,int64 user_id,const char *foreign_clickid,const char*clickid_str,int64 smartlink_id,int64 smartlink_offer_id,float payout)
{
	init();
	this->mode				=mode;
	memset(this->ip,0,12);
	memset(this->payout_ip,0,12);

	this->ip_str=ip;
	if (strstr(ip,":")==NULL) {
		this->ip[0]=1;
		inet_pton(AF_INET,ip,this->ip+4);
	} else {
		this->ip[0]=2;
		inet_pton(AF_INET6,ip,this->ip+4);
	}
	this->ua				=ua;
	this->offer_id			=offer_id;
	this->user_id			=user_id;
	this->clickid_str		=clickid_str;
	this->smartlink_id		=smartlink_id;
	this->smartlink_offer_id=smartlink_offer_id;
	this->foreign_clickid	=foreign_clickid;
	this->payout_http		=payout;
	evb = evbuffer_new();
}

/**
 * Method: Tracker::parse
 */
void Tracker::parse()
{
	int64 i;
	int32 region_tmp;
	GeoIPRecord *gir;

	region_id=0;
	gir=GeoIP_record_by_name(ts->geoip,ip_str);
	if (gir!=NULL) {
		i=gir->country_code[0];
		if (i>='a' && i<='z') i-=32;
		region_tmp=i;
		i=gir->country_code[1];
		if (i>='a' && i<='z') i-=32;
		region_tmp+=i<<8;
		region_id=ts->memcache->get_region(region_tmp);
//		printf("Tracker::parse() - ip_str=%s, country_code=%s, region_tmp=%d, region_id=%d\n",ip_str,gir->country_code,region_tmp,region_id);
		GeoIPRecord_delete(gir);
	}
	if (!region_id) region_id=116; // US
	if (force_region_id) region_id=force_region_id;

	user_agent_id=ts->get_useragent(ua);
	if (strstr(ua,"Android")) {
		device_id=4;
	} else if (strstr(ua,"iPod")) {
		device_id=3;
	} else if (strstr(ua,"iPad")) {
		device_id=1;
	} else if (strstr(ua,"iPhone")) {
		device_id=2;
	} else if (strstr(ua,"iOS")) {
		device_id=6;
	} else {
		device_id=9;
	}
	if (force_device_id) device_id=force_device_id;
	
	if (clickid_str) {
		int cnt=sscanf(clickid_str,"%d_%d_%d",&clickid_entryno,&clickid_fileno,&clickid_nodeno);
		if (cnt!=3) {
			clickid_entryno=-1;
			fprintf(stderr,"Tracker::parse() - could not parse clickid_str=%s\n",clickid_str);
		}
	}
}

/**
 * Method: Tracker::work
 */
void Tracker::dump()
{
//	struct tm click_date;
//	click_date.

	char *click_date_str=NULL;
	char *payout_date_str=NULL;
	char ip_str[128];
	char payout_ip_str[128];
	ip_str[0]=0;
	payout_ip_str[0]=0;

	switch (ip[0]) {
		case 1:
			inet_ntop(AF_INET,ip+4,ip_str,124);
			break;
		case 2:
			inet_ntop(AF_INET6,ip+4,ip_str,124);
			break;
	}

	switch (payout_ip[0]) {
		case 1:
			inet_ntop(AF_INET,payout_ip+4,payout_ip_str,124);
			break;
		case 2:
			inet_ntop(AF_INET6,payout_ip+4,payout_ip_str,124);
			break;
	}

	if (click_date) click_date_str=ctime((const time_t*)&click_date);
	if (payout_date) payout_date_str=ctime((const time_t*)&payout_date);
	//strftime(tmp,1000,"%H:%M:%S %d.%m.%Y",&click_date);
	printf("TRACKER DUMP STARTS\n");
							printf("	clickid           =%d_%d_%d\n",clickid_entryno,clickid_fileno,clickid_nodeno);
	if (click_date_str)		printf("	click_date        =%s"  ,click_date_str);
							printf("	offer_id          =%d\n",offer_id);
							printf("	user_id           =%d\n",user_id);
							printf("	ip                =%s\n",ip_str);
							printf("	region_id         =%d\n",region_id);
							printf("	checks            =%d\n",checks);
							printf("	user_agent_id     =%d\n",user_agent_id);
							printf("	device_id         =%d\n",device_id);
							printf("	smartlink_offer_id=%d\n",smartlink_offer_id);
	if (foreign_clickid)	printf("	foreign_clickid   =%s\n",foreign_clickid);
	if (aff_source) 		printf("	aff_source        =%s\n",aff_source);
	if (aff_sub   )			printf("	aff_sub           =%s\n",aff_sub   );
	if (aff_sub2  )			printf("	aff_sub2          =%s\n",aff_sub2  );
	if (aff_sub3  )			printf("	aff_sub3          =%s\n",aff_sub3  );
	if (aff_sub4  )			printf("	aff_sub4          =%s\n",aff_sub4  );
	if (aff_sub5  )			printf("	aff_sub5          =%s\n",aff_sub5  );
	if (aff_pb    )			printf("	aff_pb            =%s\n",aff_pb    );
	if (referer   )			printf("	referer           =%s\n",referer   );
							printf("	gif_rnd           =%d\n",gif_rnd   );
							printf("	js_user_agent_id  =%d\n",js_user_agent_id);
							printf("	js_width          =%d\n",js_width  );
							printf("	js_height         =%d\n",js_height );
	if (payout_date_str)	printf("	payout_date       =%s"  ,payout_date_str); else printf("	payout_date       =NULL\n");
							printf("	payout_db         =%f\n",payout_db);
							printf("	payout_db_aff     =%f\n",payout_db_aff);
							printf("	payout_db_usd     =%f\n",payout_db_usd);
							printf("	currency_db_id    =%d\n",currency_db_id);
							printf("	payout_http       =%f\n",payout_http);
							printf("	payout_ip         =%s\n",payout_ip_str);
	printf("TRACKER DUMP ENDS\n\n");
}


/**
 * Method: Tracker::calc_db_payouts
 */
void Tracker::calc_db_payouts(OfferInfo *oi)
{
	if (oi==NULL) {
		if (ts->memcache) oi=ts->memcache->get_offer(offer_id,-1,-1,user_id);
		if (oi) oi->add_ref();
	}
	Offer *offer;
	if (!oi) {
//		fprintf(stderr,"Tracker::calc_db_payouts() - offer is dead\n");
		offer=ts->get_offer(offer_id);
	} else {
		offer=oi->offer;
	}
	payout_db		=offer->payout;
	payout_db_usd	=offer->payout_usd;
	currency_db_id	=offer->currency_id;
	payout_db_aff=ts->memcache->calc_payout_aff(payout_db,payout_db_usd);
	if (oi) oi->del_ref();
//	printf("offer %ld payouts = %f %f %f currency=%d\n",offer_id,payout_db,payout_db_usd,payout_db_aff,currency_id);
}

/**
 * Method: Tracker::work
 */
void Tracker::work()
{
	switch (mode) {
		case MODE_INDEX:
			work__index();
			break;
		case MODE_GIF:
			work__gif();
			break;
		case MODE_JS:
			work__js();
			break;
		case MODE_AJAX:
			work__ajax();
			break;
		case MODE_POSTBACK:
			work__postback();
			break;
		case MODE_OFFERWALL:
			work__offerwall();
			break;
		case MODE_SMARTPOPUP:
			work__smartpopup();
			break;
		case MODE_SMARTOFFER:
			work__smartoffer();
			break;
		case MODE_SYSTEM:
			work__system();
			break;
		default:
			work__offerwall();
//			work__error("Unknown mode");
			break;
	}
}

/**
 * Method: Tracker::work__index
 */
void Tracker::work__index()
{
	if (DEBUG>2) printf("Tracker::work__index();\n");
	if (offer_id==0 || user_id==0) { 
		smartlink_id=0;
		work__offerwall();
		return;
	}
	OfferInfo *oi;
	oi=ts->memcache->get_offer(offer_id,ignore_region?-1:region_id,ignore_device?-1:device_id,user_id);
	if (!oi) {
		smartlink_id=0;
		work__offerwall();
		return;
	}
	work__sysredirect(oi);
}

/**
 * Method: Tracker::work__sysredirect
 */
void Tracker::work__sysredirect(OfferInfo *oi)
{
	gif_rnd=rand()&65535;
	offer_id=oi->offer->id;
	calc_db_payouts(oi);
	if (oi->slo_id) smartlink_offer_id=oi->slo_id;
	ts->tmpstr_set(oi->offer->tracking_url);
//	if ($affid && $affre1 && $affre2) { $affre2=~s/\{\{affid\}\}/$affid/;$url=~s/$affre1/$affre2/; }

	struct timeval tv;
	struct timezone tz;
	gettimeofday(&tv,&tz);
	click_date=tv.tv_sec;

	while (!writer_now->write_message(this)) {
		int fn=writer_now->fileno;
		delete writer_now;
		printf("	Tracker::work__index() - switching to next file (%d)\n",fn+1);
		writer_now=new Writer(NODENO,fn+1,WRITER_APPEND);
	}

	// TODO cookie
	sprintf(ts->tmpstr2,"%d_%d_%d",this->clickid_entryno,this->clickid_fileno,this->clickid_nodeno);
	sprintf(ts->tmpstr3,"%d",user_id);
	ts->tmpstr_replace("{clickid}",ts->tmpstr2);
	ts->tmpstr_replace("{click_id}",ts->tmpstr2);
	ts->tmpstr_replace("{source}",aff_source);
	ts->tmpstr_replace("{aff_sub2}",aff_sub2);
	ts->tmpstr_replace("{user_id}",ts->tmpstr3);
	ts->tmpstr_replace("{ios_idfa}",NULL);	// TODO {ios_idfa}
	ts->tmpstr_replace("{android_aid}",NULL);	// TODO {android_aid}

	strcpy(ts->tmpstr4,ts->tmpstr);

	ts->tmpstr_set(ts->tpl_index_success->get());

	ts->tmpstr_replace("{user_id}",ts->tmpstr3);
	ts->tmpstr_replace("{source}",aff_source);

	sprintf(ts->tmpstr2,"%d",this->clickid_entryno);
	ts->tmpstr_replace("{clickid_entryno}",ts->tmpstr2);

	sprintf(ts->tmpstr2,"%d",this->clickid_fileno);
	ts->tmpstr_replace("{clickid_fileno}",ts->tmpstr2);

	sprintf(ts->tmpstr2,"%d",this->clickid_nodeno);
	ts->tmpstr_replace("{clickid_nodeno}",ts->tmpstr2);

	sprintf(ts->tmpstr2,"%d",gif_rnd);
	ts->tmpstr_replace("{gif_rnd}",ts->tmpstr2);

	sprintf(ts->tmpstr2,"%ld",offer_id);
	ts->tmpstr_replace("{offer_id}",ts->tmpstr2);

	ts->tmpstr_replace("{url}",ts->tmpstr4);

//	ts->tmpstr_replace("{offer_name}",oi->offer->name);

	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));

	delete oi;
}

/**
 * Method: Tracker::html_header
 */
void Tracker::html_header(const char *header)
{
	content_type=ct_html;
	ts->tmpstr_set(ts->tpl_header->get());
	ts->tmpstr_replace("{header}",header);
	if (ua!=NULL) {
        if (strstr(ua,"opera")!=NULL || strstr(ua,"Opera")!=NULL) {
			ts->tmpstr_replace("{viewport}","");
		} else if (strstr(ua,"safari")!=NULL || strstr(ua,"Safari")!=NULL) {
			ts->tmpstr_replace("{viewport}","<meta name='viewport' content='width=320, user-scalable=no'>\n");
		} else {
			ts->tmpstr_replace("{viewport}","<meta name='viewport' content='width=100%, user-scalable=no'>\n");
		}
	}
	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
}

/**
 * Method: Tracker::html_footer
 */
void Tracker::html_footer()
{
	ts->tmpstr_set(ts->tpl_footer->get());
	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
}

/**
 * Method: Tracker::work__smartoffer
 */
void Tracker::work__smartoffer()
{
	int i,cnt;
	int pos;
	Smartlink *sl;
	OfferInfo *oi;
	if (smartlink_id==0) {
		smartlink_id=ts->memcache->min_smartlink_id;
		if (!smartlink_id) smartlink_id=1;
	}
	if (DEBUG>2) printf("Tracker::work__smartoffer();\n");
	sl=dynamic_cast<Smartlink*>(ts->memcache->smartlinks->get(smartlink_id));
//	printf("Tracker::work__offerwall() - smartlink_id=%d, min_smartlink_id=%d\n",smartlink_id,ts->memcache->min_smartlink_id);
	if (sl==NULL) {
		work__error("No offerwalls available at all! :(");
		return;
	}
	if (!user_id) user_id=sl->user_id;
	RandomSequence *rs=new RandomSequence(sl->length);
	oi=NULL;
	while (rs->has_next() && !oi) {
		i=rs->next();
		oi=ts->memcache->get_offer(sl->offers[i],ignore_region?-1:region_id,ignore_device?-1:device_id,user_id);
		if (oi) oi->slo_id=sl->ids[i];
	}
	delete rs;
	if (oi) {
		work__sysredirect(oi);
		return;
	}
	work__offerwall();
}

/**
 * Method: Tracker::work__offerwall
 */
void Tracker::work__offerwall()
{
	int i,cnt;
	Smartlink *sl;
	OfferInfo *oi;
	if (smartlink_id==0) {
		smartlink_id=ts->memcache->min_smartlink_id;
		if (!smartlink_id) smartlink_id=1;
	}
	if (DEBUG>2) printf("Tracker::work__offerwall();\n");
	sl=dynamic_cast<Smartlink*>(ts->memcache->smartlinks->get(smartlink_id));
//	printf("Tracker::work__offerwall() - smartlink_id=%d, min_smartlink_id=%d\n",smartlink_id,ts->memcache->min_smartlink_id);
	if (sl==NULL) {
		work__error("No offerwalls available at all! :(");
		return;
	}
	if (!user_id) user_id=sl->user_id;
	html_header("Best offers");
	ts->tmpstr_set(ts->tpl_offerwall_header->get());
	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
	i=0;
	cnt=0;
	RandomSequence *rs=new RandomSequence(sl->length);
	while (cnt<10 && rs->has_next()) {
		i=rs->next();
		oi=ts->memcache->get_offer(sl->offers[i],ignore_region?-1:region_id,ignore_device?-1:device_id,user_id);
		if (!oi) continue;
		ts->tmpstr_set(ts->tpl_offerwall_item->get());
		sprintf(ts->tmpstr2,"%ld",oi->offer->id);			ts->tmpstr_replace("{offer_id}",ts->tmpstr2);
		sprintf(ts->tmpstr2,"%d",user_id);					ts->tmpstr_replace("{user_id}",ts->tmpstr2);
		sprintf(ts->tmpstr2,"%d",smartlink_id);				ts->tmpstr_replace("{smartlink_id}",ts->tmpstr2);
		sprintf(ts->tmpstr2,"%ld",sl->ids[i]);				ts->tmpstr_replace("{slo_id}",ts->tmpstr2);
		ts->tmpstr_replace("{app_cover_image}",oi->offer->app_cover_image);
		ts->tmpstr_replace("{app_name}",oi->offer->app_name);
		ts->tmpstr_replace("{aff_sub}",aff_sub);
		ts->tmpstr_replace("{aff_sub2}",aff_sub2);
		ts->tmpstr_replace("{foreign_clickid}",foreign_clickid);
		sprintf(ts->tmpstr2,"%ld",sl->ids[i]);				ts->tmpstr_replace("{smartlink_offer_id}",ts->tmpstr2);
		ts->tmpstr_replace("{app_genre_name}",(oi->offer->app_genre_name && oi->offer->app_genre_name[0]!=0)?oi->offer->app_genre_name:"Cool app!");
		if (ignore_device) ts->tmpstr_replace("{ignore_device}","1"); else ts->tmpstr_replace("{ignore_device}","");
		if (ignore_region) ts->tmpstr_replace("{ignore_region}","1"); else ts->tmpstr_replace("{ignore_region}","");
		if (oi->offer->is_ios)		ts->tmpstr_replace("{platform}","ios");
		if (oi->offer->is_android)	ts->tmpstr_replace("{platform}","android");
		evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
		cnt++;
	}
	delete rs;
	ts->tmpstr_set(ts->tpl_offerwall_footer->get());
	sprintf(ts->tmpstr2,"%ld",offer_id);				ts->tmpstr_replace("{offer_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%ld",region_id);				ts->tmpstr_replace("{region_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%d",device_id);				ts->tmpstr_replace("{device_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%d",force_device_id);			ts->tmpstr_replace("{force_device_id}",ts->tmpstr2);
	ts->tmpstr_replace("{ignore_device}",ignore_device?"yes":"false");
	ts->tmpstr_replace("{ignore_region}",ignore_region?"yes":"false");
	ts->tmpstr_replace("{last_update}",ts->memcache->last_update);
	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
	html_footer();
}

/**
 * Method: Tracker::work__smartpopup
 */
void Tracker::work__smartpopup()
{
	content_type=ct_js;
	Smartlink *sl;
	OfferInfo *oi;
	Array *a;
	Banner *b;
	if (smartlink_id==0) {
		evbuffer_add_printf(evb,"/* no smartlink id provided */\n");
		evbuffer_add_printf(evb,"console.log(\"offermon.com: no smartlink id provided\");\n");
		return;
	}
	sl=dynamic_cast<Smartlink*>(ts->memcache->smartlinks->get(smartlink_id));
	if (!sl) {
		evbuffer_add_printf(evb,"/* smartlink does not exist */\n");
		evbuffer_add_printf(evb,"console.log(\"offermon.com: smartlink does not exist\");\n");
		return;
	}
	if (!user_id) user_id=sl->user_id;
	int i,pos;
	RandomSequence *rs=new RandomSequence(sl->length);
	oi=NULL;
	while (!oi && rs->has_next()) {
		i=rs->next();
		oi=ts->memcache->get_offer(sl->offers[i],ignore_region?-1:region_id,ignore_device?-1:device_id,user_id);
		if (!oi) continue;
		a=dynamic_cast<Array*>(ts->memcache->banners->get(oi->offer->id));
		if (!a) {
			delete oi;
			oi=NULL;
			continue;
		}
//		ois_preselected_push(oi,sl->ids[i]);
	}
	delete rs;
	b=NULL;
	if (!oi) {
		evbuffer_add_printf(evb,"/* no offers for region_id=%ld device_id=%ld */\n",region_id,device_id);
		evbuffer_add_printf(evb,"console.log(\"offermon.com: no offers for region_id=%ld device_id=%ld\");\n",region_id,device_id);
		return;
	}
	if (a->size==1) pos=0; else pos=(rand())%(a->size);
	b=dynamic_cast<Banner*>(a->array[pos]);
	ts->tmpstr_set(ts->tpl_mbpopup_success->get());

	sprintf(ts->tmpstr2,"%ld",oi->offer->id);			ts->tmpstr_replace("{offer_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%ld",region_id);				ts->tmpstr_replace("{region_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%d",device_id);				ts->tmpstr_replace("{device_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%d",b->id);					ts->tmpstr_replace("{banner_id}",ts->tmpstr2);
	sprintf(ts->tmpstr2,"%d",user_id);					ts->tmpstr_replace("{user_id}",ts->tmpstr2);

	ts->tmpstr_replace("{banner_name}",b->name);
	ts->tmpstr_replace("{banner_description}",b->description);
	ts->tmpstr_replace("{banner_logo_url}",b->logo_url);
	ts->tmpstr_replace("{banner_image_url}",b->image_url);

	delete oi;
	evbuffer_add(evb,ts->tmpstr,strlen(ts->tmpstr));
}

/**
 * Method: Tracker::work__gif
 */
void Tracker::work__gif()
{
	content_type=ct_gif;
	if (DEBUG>2) printf("Tracker::work__gif();\n");
	if (clickid_fileno==0 || clickid_nodeno==0 || clickid_entryno<0 || gif_rnd==0) { work__error("GIF / Required arguments are missing."); return; }
	if (clickid_entryno==-1) {
		fprintf(stderr,"Tracker::work__gif() - clickid_entryno==-1\n");
		return;
	}
	if (clickid_nodeno!=NODENO) {
		reject("Tracker::work__gif() - wrong nodeno - clickid=%d-%d-%d",clickid_entryno,clickid_fileno,clickid_nodeno);
		return;
	}
	Writer *w=writer_get(clickid_fileno);
	w->set_message_flag(this);

	evbuffer_add(evb,ts->giffile_ptr,ts->giffile_size);
}

/**
 * Method: Tracker::work__js
 */
void Tracker::work__js()
{
	if (DEBUG>2) printf("Tracker::work__js();\n");
	if (clickid_fileno==0 || clickid_nodeno==0 || clickid_entryno<0) { work__error("JS / Required arguments are missing."); return; }
	if (clickid_entryno==-1) {
		fprintf(stderr,"Tracker::work__js() - clickid_entryno==-1\n");
		return;
	}
	if (clickid_nodeno!=NODENO) {
		reject("Tracker::work__js() - wrong nodeno - clickid=%d-%d-%d",clickid_entryno,clickid_fileno,clickid_nodeno);
		return;
	}
	// TODO work__js
	js_user_agent_id=ts->get_useragent(js_ua);
}

/**
 * Method: Tracker::work__ajax
 */
void Tracker::work__ajax()
{
	if (DEBUG>2) printf("Tracker::work__ajax();\n");
	if (clickid_fileno==0 || clickid_nodeno==0 || clickid_entryno<0) { work__error("AJAX / Required arguments are missing."); return; }
	if (clickid_entryno==-1) {
		fprintf(stderr,"Tracker::work__ajax() - clickid_entryno==-1\n");
		return;
	}
	if (clickid_nodeno!=NODENO) {
		reject("Tracker::work__ajax() - wrong nodeno - clickid=%d-%d-%d",clickid_entryno,clickid_fileno,clickid_nodeno);
		return;
	}
	js_user_agent_id=ts->get_useragent(js_ua);
	Writer *w=writer_get(clickid_fileno);
	w->set_message_flag(this);
	evbuffer_add(evb,"{}",3);
}

/**
 * Method: Tracker::work__postback
 */
void Tracker::work__postback()
{
	if (DEBUG>2) printf("Tracker::work__postback();\n");
	if (clickid_fileno==0 || clickid_nodeno==0 || clickid_entryno<0) { work__error("POSTBACK / Required arguments are missing."); return; }
	if (clickid_entryno==-1) {
		fprintf(stderr,"Tracker::work__postback() - clickid_entryno==-1\n");
		return;
	}
	if (clickid_nodeno!=NODENO) {
		reject("Tracker::work_postback() - wrong nodeno - clickid=%d-%d-%d payout=%f ip=%s",clickid_entryno,clickid_fileno,clickid_nodeno,payout_http,ip);
		return;
	}
	payout_user_agent_id=ts->get_useragent(ua);
	memmove(this->payout_ip,this->ip,12);

	Writer *w=writer_get(clickid_fileno);
	w->set_message_payout(this);
	evbuffer_add_printf(evb, "OK\n");

	reject("Tracker::work_postback() - cannot sub-postback yet clickid=%d-%d-%d",clickid_entryno,clickid_fileno,clickid_nodeno);

	Tracker *tmp=w->read_message(this->clickid_entryno);
	this->user_id=tmp->user_id;

	UserPostbacks *upb=dynamic_cast<UserPostbacks*>(ts->memcache->user_postbacks->get(this->user_id));
	if (upb) {
		upb->send(tmp);
	}

	delete tmp;
	// TODO send postback to next level
	
}

/**
 * Method: Tracker::work__error
 */
void Tracker::work__error(const char *err)
{
	fprintf(stderr,"Tracker::work__error() - %s\n",err);
	html_header("offermon.com");
	evbuffer_add_printf(evb, "	<div class='page-header'>ERROR</div>\n");
	evbuffer_add_printf(evb, "	<div class='text'>%s</div>\n",err);
	html_footer();
}

/**
 * Method: Tracker::work__system
 */
void Tracker::work__system()
{
	html_header("offermon.com");
	evbuffer_add_printf(evb, "	<div class='page-header'>COMMAND ACCEPTED</div>\n");
	evbuffer_add_printf(evb, "	<div class='text'>System command in progress</div>\n");
	html_footer();
}

/**
 * Method: Tracker::evbuffer_dump
 */
void Tracker::evbuffer_dump()
{
	char *data;
	int datalen;
	datalen=evbuffer_get_length(evb);
	data=(char*)malloc(datalen+2);
	data[datalen]=0;
	evbuffer_copyout(evb,data,datalen+1);
	printf("%s",data);
	free(data);
}

/**
 * Method: Tracker::evbuffer_send
 */
void Tracker::evbuffer_send()
{
	if (content_type) evhttp_add_header(evhttp_request_get_output_headers(req),"Content-Type", content_type);
	evhttp_send_reply(this->req, HTTP_OK, "", evb);
}

/**
 * Method: Tracker::ois_preselected_init
 */
void Tracker::ois_preselected_init()
{
	ois_preselected_pos=0;
	ois_preselected=(OfferInfo**)malloc(sizeof(OfferInfo*)*OIS_PRESELECTED_MAX);
}

/**
 * Method: Tracker::ois_preselected_push
 */
bool Tracker::ois_preselected_push(OfferInfo *oi,int64 slo_id)
{
	if (!oi) return false;
	if (ois_preselected_pos>=OIS_PRESELECTED_MAX) {
		delete oi;
		return true;
	}
	oi->slo_id=slo_id;
	ois_preselected[ois_preselected_pos]=oi;
	ois_preselected_pos++;
	return false;
}

/**
 * Method: Tracker::ois_preselected_get_random
 */
OfferInfo *Tracker::ois_preselected_get_random()
{
	if (!ois_preselected_pos) {
		printf("Tracker::ois_preselected_get_random() - return NULL\n");
		return NULL;
	}
	int i=rand()%ois_preselected_pos;
	printf("Tracker::ois_preselected_get_random() - return %d of %d\n",i,ois_preselected_pos);
	OfferInfo *oi=ois_preselected[i];
	ois_preselected_pos--;
	while (i<ois_preselected_pos) {
		ois_preselected[i]=ois_preselected[i+1];
		i++;
	}
	return oi;
}

/**
 * Method: Tracker::ois_preselected_free
 */
void Tracker::ois_preselected_free()
{
	if (!ois_preselected) return;
	for (int i=0;i<ois_preselected_pos;i++) {
		if (ois_preselected[i]) delete ois_preselected[i];
	}
	ois_preselected_pos=0;
	free(ois_preselected);
	ois_preselected=NULL;
}


const char *Tracker::classname() { return "Tracker"; }
