#include <stdio.h>
#include <stdlib.h>
#include <memory>
//#include <cstdint>
#include <iostream>
#include <arpa/inet.h>

#include "offermon/tracker_static.h"
#include "offermon/template_file.h"
#include "offermon/memcache.h"
#include "offermon/writer.h"

#define DEBUG 0

pthread_mutex_t dbh_mutex1;
pthread_mutex_t dbh_mutex2;

/**
 * Method: TrackerStatic::new
 */
TrackerStatic::TrackerStatic()
{
	geoip=NULL;
	giffile_ptr=NULL;
	memcache=NULL;
	_memcache_new=NULL;
	dbh1=NULL;
	dbh2=NULL;
	last_cached_offer=NULL;
	useragents=new Hash();
	useragents->add_ref();

	geoip=GeoIP_open("/usr/local/share/GeoIP/GeoIPCity.dat", GEOIP_INDEX_CACHE);
	if (geoip == NULL) {
		fprintf(stderr, "TrackerStatic::TrackerStatic() - GeoIP_open() - error opening database\n");
		exit(1);
	}
	FILE *tmp;
	tmp=fopen("/home/projects/lattenoir/html/shared/empty.gif","r");
	if (!tmp) {
		fprintf(stderr, "TrackerStatic::TrackerStatic() - no file /home/projects/lattenoir/html/shared/empty.gif\n");
		exit(1);
	}
	fseek(tmp,0,SEEK_END);
	int i=ftell(tmp);
	fseek(tmp,0,SEEK_SET);
	giffile_ptr=(char*)malloc(i);
	giffile_size=i;
	fread(giffile_ptr,1,giffile_size,tmp);
	fclose(tmp);
	tpl_mbpopup_success=new TemplateFile("views/mbpopup/success.js");
	tpl_mbpopup_success->add_ref();
	tpl_index_success=new TemplateFile("views/index/success.html");
	tpl_index_success->add_ref();
	tpl_offerwall_header=new TemplateFile("views/offerwall/header.html");
	tpl_offerwall_header->add_ref();
	tpl_offerwall_item=new TemplateFile("views/offerwall/item.html");
	tpl_offerwall_item->add_ref();
	tpl_offerwall_footer=new TemplateFile("views/offerwall/footer.html");
	tpl_offerwall_footer->add_ref();
	tpl_header=new TemplateFile("views/_header.html");
	tpl_header->add_ref();
	tpl_footer=new TemplateFile("views/_footer.html");
	tpl_footer->add_ref();
}

/**
 * Method: TrackerStatic::delete
 */
TrackerStatic::~TrackerStatic()
{
	if (useragents) useragents->del_ref();
	if (memcache) delete memcache;
	if (_memcache_new) delete _memcache_new;
	if (geoip) GeoIP_delete(geoip);
	if (giffile_ptr) free(giffile_ptr);
	tpl_mbpopup_success->del_ref();
	tpl_index_success->del_ref();
	tpl_offerwall_header->del_ref();
	tpl_offerwall_item->del_ref();
	tpl_offerwall_footer->del_ref();
	tpl_header->del_ref();
	tpl_footer->del_ref();
	if (dbh1) PQfinish(dbh1);
	if (dbh2) PQfinish(dbh2);
	if (last_cached_offer) last_cached_offer->del_ref();
}

/**
 * Method: TrackerStatic::db_connect
 */
void TrackerStatic::db_connect()
{
	dbh1=PQsetdbLogin("46.4.59.135","5432","","","combine_erp_offermon","combine_erp_offermon","");
	if (PQstatus(dbh1) != CONNECTION_OK) {
		fprintf(stderr, "Connection to database failed: %s\n",PQerrorMessage(dbh1));
		exit(1);
	}
	PQsetClientEncoding(dbh1, "UTF-8");
	pthread_mutex_init(&dbh_mutex1,NULL);
	dbh2=PQsetdbLogin("46.4.59.135","5432","","","combine_erp_offermon","combine_erp_offermon","");
	if (PQstatus(dbh2) != CONNECTION_OK) {
		fprintf(stderr, "Connection to database failed: %s\n",PQerrorMessage(dbh2));
		exit(1);
	}
	PQsetClientEncoding(dbh2, "UTF-8");
	pthread_mutex_init(&dbh_mutex2,NULL);
}

/**
 * Method: TrackerStatic::db_preload
 */
void TrackerStatic::db_preload()
{
	char *name;
	int64 id,i;
	PGresult *res;
	pthread_mutex_lock(&dbh_mutex1);
	res = PQexec(dbh1,"select id,name from Tuser_agents");// TODO limit it
	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
		fprintf(stderr, "SELECT failed (Tuser_agents 1):\n%s\n", PQerrorMessage(dbh1));
		exit(1);
	}
	for (i=0;i<PQntuples(res);i++) {
		id=atol(PQgetvalue(res,i,0));
		name=PQgetvalue(res,i,1);
		useragents->put(new Blob(name,strlen(name)),new Int64(id));
	}
	PQclear(res);
	pthread_mutex_unlock(&dbh_mutex1);
}

/**
 * Method: TrackerStatic::get_useragent
 */
int64 TrackerStatic::get_useragent(const char* str)
{
	if (str==NULL) str="-null-";
	const char *pv[1];
	char *name;
	int64 id;
	PGresult *res;
	//BlobPtr *b=new BlobPtr(str,strlen(str));

	BlobPtr *bp=new BlobPtr(str,strlen(str));
	bp->add_ref();
	Int64 *i=dynamic_cast<Int64*>(useragents->get(bp));
	bp->del_ref();	
	if (i) {
//		printf("TrackerStatic::get_useragent(%s)=%d (cache, size=%d)\n",str,i->value,useragents->size);
		return i->value;
	}

	// not in cache but in the database
	pv[0]=str;
	Blob *b=new Blob(str,strlen(str));
	b->add_ref();
	pthread_mutex_lock(&dbh_mutex2);
	res = PQexecParams(dbh2,"select id from Tuser_agents where name=$1",1,NULL,pv,NULL,NULL,0);
	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
		fprintf(stderr, "SELECT failed (Tuser_agents 2):\n%s\n", PQerrorMessage(dbh2));
		exit(1);
	}
	if (PQntuples(res)) {
		id=atol(PQgetvalue(res,0,0));
		useragents->put(b,new Int64(id));
		PQclear(res);
		pthread_mutex_unlock(&dbh_mutex2);
		b->del_ref();	
//		printf("TrackerStatic::get_useragent(%s)=%d (select)\n",str,id);
		return id;
	}
	PQclear(res);
	pthread_mutex_unlock(&dbh_mutex2);

	//insert
	pthread_mutex_lock(&dbh_mutex2);
	res = PQexecParams(dbh2,"insert into Tuser_agents (name,is_robot,device_type) values ($1,0,1) returning id",1,NULL,pv,NULL,NULL,0);
	if (PQresultStatus(res) != PGRES_TUPLES_OK) {
		fprintf(stderr, "INSERT failed (Tuser_agents):\n%s\n", PQerrorMessage(dbh2));
		exit(1);
	}
	if (!PQntuples(res)) {
		fprintf(stderr, "SOMETHING STRANGE - INSERT failed: %s", PQerrorMessage(dbh2));
		exit(1);
	}
	id=atol(PQgetvalue(res,0,0));
	useragents->put(b,new Int64(id));
	PQclear(res);
	pthread_mutex_unlock(&dbh_mutex2);
	b->del_ref();	
//	printf("TrackerStatic::get_useragent(%s)=%d (insert)\n",str,id);
	return id;
}

/**
 * Method: TrackerStatic::memcache_set
 */
void TrackerStatic::memcache_set(Memcache *_mc)
{
	if (memcache) delete memcache;
	memcache=_mc;
}

/**
 * Method: TrackerStatic::memcache_from_file
 */
void TrackerStatic::memcache_from_file()
{
	FILE *in;
	int64 size;
	char *tmp;
	Memcache *mc;
	in=fopen("/tmp/memcache.dat","r");
	if (!in) {
		fprintf(stderr,"TrackerStatic::memcache_from_file() - cannot open file()");
		return;
	}
	fseek(in,0,SEEK_END);
	size=ftell(in);
	fseek(in,0,SEEK_SET);
	tmp=(char*)malloc(size);
	fread(tmp,1,size,in);
	fclose(in);
	memcache_from_string(tmp,size);
	free(tmp);
}

/**
 * Method: TrackerStatic::memcache_from_string
 */
void TrackerStatic::memcache_from_string(char *str,int size)
{
	Memcache *mc=new Memcache();
	if (mc->load(str,size)) {
		memcache_set(mc);
	} else {
		free(mc);
	}
}

/**
 * Method: TrackerStatic::memcache_from_db
 */
void TrackerStatic::memcache_from_db()
{
	if (_memcache_new) return;
	_memcache_new=new Memcache();
	_memcache_new->load(dbh1);
}

/**
 * Method: TrackerStatic::memcache_from_db_done
 */
void TrackerStatic::memcache_from_db_done()
{
	printf("TrackerStatic::memcache_from_db_done() - installing new memcache\n");
	memcache_set(_memcache_new);
	_memcache_new=NULL;
}

/**
 * Method: TrackerStatic::memcache_to_file
 */
void TrackerStatic::memcache_to_file()
{
	WriteStream *ws=new WriteStream();
	ws->file_open("/tmp/memcache.dat");
	memcache->save(ws);
	delete ws;
}

/**
 * Method: TrackerStatic::tmpstr_set
 */
void TrackerStatic::tmpstr_set(const char *str)
{
	strncpy(tmpstr,str,TMPSTR_MAX-1);
	tmpstr[TMPSTR_MAX-1]=0;
}

/**
 * Method: TrackerStatic::tmpstr_replace
 */
void TrackerStatic::tmpstr_replace(const char *what,const char *with)
{
	int s0=strlen(tmpstr);
	int s1=strlen(what);
	int s2=0;
	if (with!=NULL) s2=strlen(with);
	if (s1>s0) return;
	int ptr=0;
	if (s0+s2-s1>TMPSTR_MAX-1) return;
	while (ptr<=s0-s1) {
		if (memcmp(tmpstr+ptr,what,s1)==0) {
			memmove(tmpstr+ptr+s2,tmpstr+ptr+s1,s0-ptr-s1+1);
			if (s2) memmove(tmpstr+ptr,with,s2);
			// update s0
			s0+=s2-s1;
			ptr+=s2;
			if (s0+s2-s1>TMPSTR_MAX-1) return;
		} else {
			ptr++;
		}
	}
}

/**
 * Method: TrackerStatic::get_offer
 */
Offer *TrackerStatic::get_offer(uint64 offer_id)
{
	if (!memcache) ts->memcache_from_db();
	int max_region_id;
	if (memcache) max_region_id=memcache->max_region_id; else max_region_id=800;
	PGresult *res;
	if (last_cached_offer) {
		if (last_cached_offer->id==offer_id) return last_cached_offer;
		last_cached_offer->del_ref();
	}
	last_cached_offer=NULL;

//	printf("TrackerStatic::get_offer(%ld)\n",offer_id);
	pthread_mutex_lock(&dbh_mutex2);
	res=Memcache::pqexec_offers_list(offer_id,dbh2);
	last_cached_offer=new Offer();
	last_cached_offer->add_ref();
	last_cached_offer->init(max_region_id);
	last_cached_offer->load(res,0);
	PQclear(res);
	pthread_mutex_unlock(&dbh_mutex2);

	return last_cached_offer;
}


const char *TrackerStatic::classname() { return "TrackerStatic"; }


