#ifndef ATOMS_LIST_H
#define ATOMS_LIST_H

#include <atoms/object.h>

/*! \brief Массив, с динамически изменяемым размером.
 *  \ingroup atoms
 *
 * Автоматически вызывает add_ref()/del_ref()
 */
class Array: public Object {
public:
	Array();
	virtual ~Array();

	virtual const char *classname();

	/*! \brief Помещает объект в массив, раздвигая массив при необходимости.
	 *  \param i Номер элемента, начиная с нуля
	 *  \param o Указатель на объект (возможно ==NULL).
	 */
	virtual void put(uint32 i,Object *o);
	
	/*! \brief Вытаскивает объект из массива или возвращает NULL.
	 *  \param i Номер элемента, начиная с нуля
	 */
	virtual Object *get(uint32 i);
	
	/*! \brief Помещает элемент в конец массива
	 *  \param o Указатель на объект (возможно ==NULL).
	 */
	virtual void push(Object *o);
	
	/*! \brief Увеличивает размер массива до указанного размера
	 *  \param _size Новый размер массива.
	 */
	virtual void grow(uint32 _size);

	/*! \brief Удаляет элемент из массива
	 *  \param pos Номер элемента в массиве
	 */
	virtual void del(uint32 pos);
	
	/*! \brief Удаляет из массива все вхождения объекта
	 */
	virtual void del(Object *o);
	
	/*! \brief Очищает массив
	 */
	virtual void empty();

	/*! \brief Добавляет в массив элементы 
	 */
	virtual void add(Array *a);

	/*! \brief Возвращает последний элемент массива, удаляя его при этом из массива и делая руками(!) object->cnt_refs--;
	 */
	virtual Object *pop();
	
	virtual bool storable_to_blob(Blob *b);	
	
	/*! \brief Массив объектов.
	 */
	Object **array;

	/*! \brief Размер массива с точки зрения внешних объектов.
	 *
	 */
	uint32 size;

	/*! \brief Размер массива с точки зрения объёма выделенной памяти.
	 */
	uint32 size_real;
};

#endif

