#ifndef FUNCS_H
#define FUNCS_H
#include <atoms/object.h>

class Text;
class Text8;
class Text32;
class Blob;

/*! \brief Вызывает add_ref() если o!=NULL
 */
void add_ref(Object *o);
/*! \brief Вызывает del_ref() если o!=NULL, приравнивает o=NULL при nrefs==0
 */
void del_ref(Object *&o);

/*! \brief Сравнивает две бинарные строки, отличается от memcmp тем что передаются два размера.
 *  \param data1 Первый массив байт
 *  \param size1 Длина первого массива
 *  \param data2 Второй массив байт
 *  \param size2 Длина второго массива
 *  
 */
int8 memcmp2(uint8 *data1,uint32 size1,uint8 *data2,uint32 size2);

Blob *text_to_blob(Text *t);
Text8 *text_to_text8(Text *t);
Text32 *text_to_text32(Text *t);

#endif

