#ifndef ATOMS_HASH_H
#define ATOMS_HASH_H

#include <atoms/object.h>
#include <atoms/text.h>
#include <atoms/array.h>


/*! \brief Тривиальный хеш. На данный момент просто хранит ключи в отсортированном виде.
 *  \ingroup atoms
 *
 */
class Hash: public Object {
public:
	Hash();
	virtual ~Hash();

	/*! \brief Вытаскивает элемент хеша по ключу
	 *  \param k Ключ
	 *  \return Значение
	 */
	virtual Object *get(Object *k);
	
	/*! \brief Сохраняет значение в хеш
	 *  \param k Ключ
	 *  \param v Значение
	 */
	virtual void put(Object *k,Object *v);

	/*! \brief Удаляет значение из хеша
	 *  \param k Ключ
	 */
	virtual void del(Object *k);

	/*! \brief Очищает хеш
	 */
	virtual void empty();


	/*! \brief Проверяет, есть ли запись с данным ключом в хеше
	 *
	 */
	virtual bool exist(Object *k);

	/*! \brief Служебный метод. Вставляет элемент перед позицией pos
	 */
	virtual void insert(int32 pos,Object *k,Object *v);
	
	/*! \brief Служебный метод. Ищет элемент.
	 *  \param k Ключ
	 *  \param pos Если ключ найден - позиция, если не найден - позиция в которую нужно вставить новый.
	 *  \param exist Флаг, найден ли ключ
	 */
	virtual void get_pos(Object *k,int32 &pos,bool &exist);

	/*! \brief Возвращает ключи хеша. Просьба не менять их.
	 */
	virtual Array *get_keys();
	
	/*! \brief Возвращает значения хеша. Просьба не менять их.
	 */
	virtual Array *get_values();

	/*! \brief Метод для отладки. Распечатывает хеш
	 */
	virtual void print_keys();

	virtual const char *classname();
	
	virtual bool storable_to_blob(Blob *b);	
	
	Object **keys;
	Object **values;
	
	/* \brief Количество элементов в хеше.
	 */
	int32 size;

	/* \brief Размер выделенной памяти.
	 */
	int32 size_real;
};

#endif

