#ifndef ATOMS_TEXT8_H
#define ATOMS_TEXT8_H

#include <atoms/text.h>

class Text32;
/*! \brief Класс хранящий строку в UTF8
 *  \ingroup atoms
 */
class Text8: public Text {
public:
	Text8();
	Text8(Text *t);
	Text8(const char *chr);
	Text8(const char *chr,uint32 size);
	virtual ~Text8();
	virtual void init_from_text8 (Text8 *txt);
	virtual void init_from_text32(Text32 *txt);
	virtual void init_from_blob  (Blob *txt);
	virtual Text *concat(Text *txt);
	virtual void add(Text *txt);
	virtual void add(const char *txt);
	virtual void add_bytes(const uint8* buf, uint32 len);
	virtual Text *substr(uint32 start,uint32 len);
	virtual const char *classname();
	virtual int8 cmp(Object *txt);
	virtual char *get_chars();
	virtual uint32 get_char(uint32 pos);
	virtual int32 index_of(Text *substr,uint32 pos=0);
	virtual Array *split(Text *substr);
	virtual uint32 calc_bytes_by_pos(uint32 pos);
	virtual bool starts_with(Text *substr);
	virtual void print();
	virtual void print(FILE *out);

	static int8 cmp(uint8 *a1,uint8 *a2,uint32 size1,uint32 size2);

	virtual char *ptr();
	virtual uint32 size_in_bytes();

	virtual bool storable_to_blob(Blob *b);	

	uint8 *text;
	uint32 size_bytes;
protected:
};

#endif
