#ifndef TRACKER_STATIC_H
#define TRACKER_STATIC_H

#include "omatoms.h"
#include <evhttp.h>

#define TMPSTR_MAX 20480
class Memcache;
class Writer;
class UserPostback;
class UserPostbacks;
class ScanStruct;
class TemplateFile;
class Offer;

extern pthread_mutex_t dbh_mutex1;
extern pthread_mutex_t dbh_mutex2;

class TrackerStatic:public Object {
	public:
		GeoIP*				geoip;
		Hash*				useragents;
/*		map<string,int64>	useragents;*/
		Memcache*			memcache;
		Memcache*			_memcache_new;
		char*				giffile_ptr;
		int					giffile_size;
		PGconn*				dbh1;
		PGconn*				dbh2;

		TrackerStatic();
		virtual ~TrackerStatic();

		virtual void db_connect();
		virtual void db_preload();
//		virtual int64 get_useragent(const string &str);
		virtual int64 get_useragent(const char *str);

		virtual void memcache_set(Memcache *_mc);
		virtual void memcache_from_file();
		virtual void memcache_from_string(char *str,int size);
		virtual void memcache_from_db();
		virtual void memcache_from_db_done();
		virtual void memcache_to_file();
		virtual const char *classname();

		virtual Offer *get_offer(uint64 offer_id);

		virtual void tmpstr_set(const char *str);
		virtual void tmpstr_replace(const char *what,const char *with);

		char			tmpstr [TMPSTR_MAX];
		char			tmpstr2[TMPSTR_MAX];
		char			tmpstr3[TMPSTR_MAX];
		char			tmpstr4[TMPSTR_MAX];

		TemplateFile	*tpl_mbpopup_success;
		TemplateFile	*tpl_index_success;
		TemplateFile	*tpl_offerwall_header;
		TemplateFile	*tpl_offerwall_item;
		TemplateFile	*tpl_offerwall_footer;
		TemplateFile	*tpl_header;
		TemplateFile	*tpl_footer;

		Offer *last_cached_offer;
};

#endif

