#include <stdio.h>
#include <atoms/blob.h>
#include <atoms/blobptr.h>
#include <atoms/text32.h>
#include <atoms/text8.h>
#include <atoms/array.h>
#include <atoms/funcs.h>
#include <atoms/utf.h>

uint8 zero_ptr_blob[1]={0};

/*****************************************************************************/
Blob::Blob()
{
	length=0;
	length_real=0;
	text=zero_ptr_blob;
}

/*****************************************************************************/
Blob::Blob(Text *txt): Text()
{
	length=0;
	length_real=0;
	if (dynamic_cast<Text8*>(txt)) {
		init_from_text8(dynamic_cast<Text8*>(txt));
	} else if (dynamic_cast<Text32*>(txt)) {
		init_from_text32(dynamic_cast<Text32*>(txt));
	} else if (dynamic_cast<Blob*>(txt)) {
		init_from_blob(dynamic_cast<Blob*>(txt));
	}
}

/*****************************************************************************/
Blob::Blob(const char *chr)
{
	length_real=length=strlen(chr);
	if (length) {
		text=(uint8*)malloc(length+1);
		memmove(text,chr,length);
		text[length]=0;
	} else {
		text=zero_ptr_blob;
	}
}

/*****************************************************************************/
Blob::Blob(const char *chr,uint32 _size_bytes)
{
	length_real=length=_size_bytes;
	if (length) {
		text=(uint8*)malloc(length+1);
		memmove(text,chr,length);
		text[length]=0;
	} else {
		text=zero_ptr_blob;
	}
}

/*****************************************************************************/
Blob::Blob(uint8 *chr,uint32 _size_bytes)
{
	length_real=length=_size_bytes;
	if (length) {
		text=(uint8*)malloc(length+1);
		memmove(text,chr,length);
		text[length]=0;
	} else {
		text=zero_ptr_blob;
	}
}


/*****************************************************************************/
Blob::~Blob()
{
	if (length_real) free(text);
}

/*****************************************************************************/
void Blob::init_from_blob(Blob *txt)
{
	length_real=length=txt->length;
	if (length) {
		text=(uint8*)malloc(length+1);
		memmove(text,txt->text,length);
		text[length]=0;
	} else {
		text=zero_ptr_blob;
	}
}

/*****************************************************************************/
void Blob::init_from_text32(Text32 *txt)
{
	assert(0);
}

/*****************************************************************************/
void Blob::init_from_text8(Text8 *txt)
{
	assert(0);
}

/*****************************************************************************/
Text *Blob::concat(Text *txt1)
{
	Blob *r=new Blob(this);
	r->add(txt1);
	return r;
}

/*****************************************************************************/
void Blob::add(const char *txt1)
{
	if (txt1==NULL) return;
	add_bytes((const uint8*)txt1,strlen(txt1));
}

/*****************************************************************************/
void Blob::add(const uint8* buf, uint32 len)
{
	if (buf == NULL || len == 0) return;
	add_bytes(buf,len);
}

/*****************************************************************************/
void Blob::add_bytes(const uint8* buf, uint32 len)
{
	if (length+len+1>=length_real) {
		uint8 *tmp=text;
		text=(uint8*)malloc((length + len)*1.3 + 1);
		memmove(text,tmp,length);
		if (length_real) free(tmp);
	}
	memmove(text+length,buf,len);
	length+=len;
	text[length]=0;
	return;
}

/*****************************************************************************/
void Blob::add(Text *txt1)
{
	if (txt1==NULL) return;
	Blob *txt=text_to_blob(txt1);
	bool del=false;
	txt->add_ref();
	add_bytes(txt->text,txt->length);
	txt->del_ref();
}

/*****************************************************************************/
Text *Blob::substr(uint32 start,uint32 len)
{
	if (start>=length) {
		return new Blob();
	}
	if (start+len>=length) {
		len=length-start;
	}
	return new Blob(text+start,len);
}

/*****************************************************************************/
const char *Blob::classname()
{
	return "Blob";
}

/*****************************************************************************/
int8 Blob::cmp(Object *txt1)
{
	if (txt1==this) return 0;
	Blob *txt=dynamic_cast<Blob*>(txt1);
	if (txt) return memcmp2(text,length,txt->text,txt->length);

	BlobPtr *txt2=dynamic_cast<BlobPtr*>(txt1);
	if (txt2) return memcmp2(text,length,txt2->text,txt2->length);

/*	bool del=false;
	Text *tmp=dynamic_cast<Text*>(txt1);
	if (!tmp) return Object::cmp(txt1);
	txt=new Blob(tmp);
	txt->add_ref();
	del=true;

	int8 rv=memcmp2(text,length,txt->text,txt->length);
	if (del) txt->del_ref();
	return rv;*/
	return Object::cmp(txt1);
}

/*****************************************************************************/
char *Blob::get_chars()
{
	char *s=(char*)malloc(sizeof(char)*(length+1));
	// TODO if uint8!=char
	// TODO: national
	memmove(s,text,length);
	s[length]=0;
	return s;
}

/*****************************************************************************/
uint32 Blob::get_char(uint32 pos)
{
	if (pos>=length) return (uint32)-1;
	return text[pos];
}

/*****************************************************************************/
int32 Blob::index_of(Text *txt1,uint32 pos)
{
	Blob *txt=text_to_blob(txt1);
	int32 rv=-1;
	txt->add_ref();
	uint32 s=txt->length;
	while (length-pos>=txt->length && rv==-1) {
		if (memcmp(text+pos,txt->text,s)==0) {
			rv=pos;
		} else {
			pos++;
		}
	}
	txt->del_ref();
	return rv;
}

/*****************************************************************************/
Array *Blob::split(Text *txt1)
{
	Blob *txt=text_to_blob(txt1);
	txt->add_ref();
	uint32 prevpos=0;
	uint32 pos=0;
	Array *a=new Array();
	while (length-pos>=txt->length) {
		if (memcmp(text+pos,txt->text,txt->length)==0) {
			a->push(new Blob(text+prevpos,pos-prevpos));
			pos+=txt->length;
			prevpos=pos;
		} else {
			pos++;
		}
	}
	a->push(new Blob(text+prevpos,length-prevpos));
	txt->del_ref();
	return a;
}

/*****************************************************************************/
Array *Blob::split(const char *text2,uint32 size2)
{
	uint32 prevpos=0;
	uint32 pos=0;
	Array *a=new Array();
	while (length-pos>=size2) {
		if (memcmp(text+pos,text2,size2)==0) {
			a->push(new Blob(text+prevpos,pos-prevpos));
			pos+=size2;
			prevpos=pos;
		} else {
			pos++;
		}
	}
	a->push(new Blob(text+prevpos,length-prevpos));
	return a;
}


/*****************************************************************************/
int32 Blob::index_of(const char *text2,uint32 size,uint32 pos)
{
	void *a=memmem(text,length,text2,size);
	if (a==NULL) return -1;
	return ((uint8*)a)-text;
}

/*****************************************************************************/
bool Blob::starts_with(Text *txt1)
{
	Blob *txt=text_to_blob(txt1);
	txt->add_ref();
	bool flag=false;
	if (txt->length<=length) {
		flag=memcmp(text,txt->text,txt->length)?false:true;
	}
	txt->del_ref();
	return flag;
}

/*****************************************************************************/
char *Blob::ptr()
{
	return (char*)text;
}

/*****************************************************************************/
uint32 Blob::size_in_bytes()
{
	return length;
}

/*****************************************************************************/
void Blob::print()
{
	printf("%s",text);
}

/*****************************************************************************/
void Blob::print(FILE *out)
{
	fprintf(out,"%s",text);
}

/*****************************************************************************/
void Blob::byte_print()
{
	print_arr (text, length);	
}

const uint8 tmpfill[]={0,0,0,0,0,0,0,0,0,0};
/*****************************************************************************/
void Blob::word_align()
{
	
	add_bytes(tmpfill,ptr_word_align(length)-length);
}

/*****************************************************************************/
uint32 ptr_word_align(uint32 s)
{
	uint32 a=(s&(PTR_WORD_ALIGN-1));
	if (a==0) return s;
	return s+PTR_WORD_ALIGN-a;
}

/*****************************************************************************/



