#include <stdio.h>
#include <atoms/blobptr.h>
#include <atoms/blob.h>
#include <atoms/text32.h>
#include <atoms/text8.h>
#include <atoms/array.h>
#include <atoms/funcs.h>
#include <atoms/utf.h>

extern uint8 zero_ptr_blob[1];

/*****************************************************************************/
BlobPtr::BlobPtr()
{
	length=0;
	text=zero_ptr_blob;
}

/*****************************************************************************/
BlobPtr::BlobPtr(Text *txt): Text()
{
	fprintf(stderr,"BlobPtr::BlobPtr(Text *txt) TODO\n");exit(1);
	length=0;
	if (dynamic_cast<Text8*>(txt)) {
		init_from_text8(dynamic_cast<Text8*>(txt));
	} else if (dynamic_cast<Text32*>(txt)) {
		init_from_text32(dynamic_cast<Text32*>(txt));
	} else if (dynamic_cast<BlobPtr*>(txt)) {
		init_from_blob(dynamic_cast<BlobPtr*>(txt));
	}
}

/*****************************************************************************/
BlobPtr::BlobPtr(const char *chr)
{
	length=strlen(chr);
	text=(uint8*)chr;
}

/*****************************************************************************/
BlobPtr::BlobPtr(const char *chr,uint32 _size_bytes)
{
	length=_size_bytes;
	text=(uint8*)chr;
}

/*****************************************************************************/
BlobPtr::BlobPtr(uint8 *chr,uint32 _size_bytes)
{
	length=_size_bytes;
	text=(uint8*)chr;
}


/*****************************************************************************/
BlobPtr::~BlobPtr()
{
	
}

/*****************************************************************************/
void BlobPtr::init_from_blob(BlobPtr *txt)
{
	length=txt->length;
	text=txt->text;
}

/*****************************************************************************/
void BlobPtr::init_from_text32(Text32 *txt)
{
	assert(0);
}

/*****************************************************************************/
void BlobPtr::init_from_text8(Text8 *txt)
{
	assert(0);
}

/*****************************************************************************/
Text *BlobPtr::concat(Text *txt1)
{
	assert(0);
}

/*****************************************************************************/
void BlobPtr::add(const char *txt1)
{
	assert(0);
}

/*****************************************************************************/
void BlobPtr::add(const uint8* buf, uint32 len)
{
	assert(0);
}

/*****************************************************************************/
void BlobPtr::add_bytes(const uint8* buf, uint32 len)
{
	assert(0);
}

/*****************************************************************************/
void BlobPtr::add(Text *txt1)
{
	assert(0);
}

/*****************************************************************************/
Text *BlobPtr::substr(uint32 start,uint32 len)
{
	assert(0);
}

/*****************************************************************************/
const char *BlobPtr::classname()
{
	return "BlobPtr";
}

/*****************************************************************************/
int8 BlobPtr::cmp(Object *txt1)
{
	if (txt1==this) return 0;
	BlobPtr *txt=dynamic_cast<BlobPtr*>(txt1);
	if (txt) {
//		printf("BlobPtr::cmp() 1 memcmp2=%d\n",memcmp2(text,length,txt->text,txt->length));
		return memcmp2(text,length,txt->text,txt->length);
	}
	Blob *txt2=dynamic_cast<Blob*>(txt1);
	if (txt2) {
/*		printf("BlobPtr::cmp() \"%s\"\n",text);
		printf("BlobPtr::cmp() \"%s\"\n",txt2->text);
		printf("BlobPtr::cmp() 2 memcmp2=%d %ld(%d) %ld(%d)\n",memcmp2(text,length,txt2->text,txt2->length),text,length,txt2->text,txt2->length);*/
		return memcmp2(text,length,txt2->text,txt2->length);
	}

/*	Text *tmp=dynamic_cast<Text*>(txt1);
	if (!tmp)*/
	return Object::cmp(txt1);
/*	int8 rv=memcmp2(text,length,tmp->text,txt2->length);
	return rv;*/
}

/*****************************************************************************/
char *BlobPtr::get_chars()
{
	assert(0);
	char *s=(char*)malloc(sizeof(char)*(length+1));
	// TODO if uint8!=char
	// TODO: national
	memmove(s,text,length);
	s[length]=0;
	return s;
}

/*****************************************************************************/
uint32 BlobPtr::get_char(uint32 pos)
{
	assert(0);
	if (pos>=length) return (uint32)-1;
	return text[pos];
}

/*****************************************************************************/
int32 BlobPtr::index_of(Text *txt1,uint32 pos)
{
	assert(0);
/*	BlobPtr *txt=text_to_blob(txt1);
	int32 rv=-1;
	txt->add_ref();
	uint32 s=txt->length;
	while (length-pos>=txt->length && rv==-1) {
		if (memcmp(text+pos,txt->text,s)==0) {
			rv=pos;
		} else {
			pos++;
		}
	}
	txt->del_ref();
	return rv;*/
}

/*****************************************************************************/
Array *BlobPtr::split(Text *txt1)
{
	assert(0);
	/*BlobPtr *txt=text_to_blob(txt1);
	txt->add_ref();
	uint32 prevpos=0;
	uint32 pos=0;
	Array *a=new Array();
	while (length-pos>=txt->length) {
		if (memcmp(text+pos,txt->text,txt->length)==0) {
			a->push(new BlobPtr(text+prevpos,pos-prevpos));
			pos+=txt->length;
			prevpos=pos;
		} else {
			pos++;
		}
	}
	a->push(new BlobPtr(text+prevpos,length-prevpos));
	txt->del_ref();
	return a;*/
}

/*****************************************************************************/
Array *BlobPtr::split(const char *text2,uint32 size2)
{
	assert(0);
	uint32 prevpos=0;
	uint32 pos=0;
	Array *a=new Array();
	while (length-pos>=size2) {
		if (memcmp(text+pos,text2,size2)==0) {
			a->push(new BlobPtr(text+prevpos,pos-prevpos));
			pos+=size2;
			prevpos=pos;
		} else {
			pos++;
		}
	}
	a->push(new BlobPtr(text+prevpos,length-prevpos));
	return a;
}


/*****************************************************************************/
int32 BlobPtr::index_of(const char *text2,uint32 size,uint32 pos)
{
	assert(0);
	void *a=memmem(text,length,text2,size);
	if (a==NULL) return -1;
	return ((uint8*)a)-text;
}

/*****************************************************************************/
bool BlobPtr::starts_with(Text *txt1)
{
	assert(0);
	/*BlobPtr *txt=text_to_blob(txt1);
	txt->add_ref();
	bool flag=false;
	if (txt->length<=length) {
		flag=memcmp(text,txt->text,txt->length)?false:true;
	}
	txt->del_ref();
	return flag;*/
}

/*****************************************************************************/
char *BlobPtr::ptr()
{
	return (char*)text;
}

/*****************************************************************************/
uint32 BlobPtr::size_in_bytes()
{
	return length;
}

/*****************************************************************************/
void BlobPtr::print()
{
	printf("%s",text);
}

/*****************************************************************************/
void BlobPtr::print(FILE *out)
{
	fprintf(out,"%s",text);
}

/*****************************************************************************/
void BlobPtr::byte_print()
{
	print_arr (text, length);	
}

const uint8 tmpfill[]={0,0,0,0,0,0,0,0,0,0};
/*****************************************************************************/
void BlobPtr::word_align()
{
	add_bytes(tmpfill,ptr_word_align(length)-length);
}

/*****************************************************************************/

