#include <stdio.h>
#include <atoms/hash.h>
#include <atoms/blob.h>

/*****************************************************************************/
Hash::Hash()
{
	size=0;
	size_real=10;
	keys=(Object**)malloc(sizeof(Object*)*size_real);
	values=(Object**)malloc(sizeof(Object*)*size_real);
}

/*****************************************************************************/
Hash::~Hash()
{
	int i;
	for (i=0;i!=size;i++) {
		keys[i]->del_ref();
		if (values[i]) values[i]->del_ref();
	}
	free(keys);
	free(values);
}

/*****************************************************************************/
void Hash::empty()
{
	int i;
	for (i=0;i!=size;i++) {
		keys[i]->del_ref();
		if (values[i]) values[i]->del_ref();
	}
	size=0;
}

/*****************************************************************************/
Object *Hash::get(Object *k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (exist) return values[pos];
	return NULL;
}

/*****************************************************************************/
void Hash::put(Object *k,Object *v)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (exist) {
		if (values[pos]) values[pos]->del_ref();
		values[pos]=v;
		if (v) v->add_ref();
	} else {
		insert(pos,k,v);
	}
	
}

/*****************************************************************************/
void Hash::insert(int32 pos,Object *k,Object *v)
{
	int32 i;
	if (size_real==size) {
		Object **keys2=keys;
		Object **values2=values;
		size_real=size_real*1.3+3;
		keys=(Object**)malloc(sizeof(Object*)*size_real);
		values=(Object**)malloc(sizeof(Object*)*size_real);
		for (i=0;i!=size;i++) {
			keys[i]=keys2[i];
			values[i]=values2[i];
		}
		free(values2);
		free(keys2);
	}
	for (i=size;i!=pos;i--) {
		keys[i]=keys[i-1];
		values[i]=values[i-1];
	}
	keys[pos]=k;
	values[pos]=v;
	k->add_ref();
	v->add_ref();
	size++;
}

/*****************************************************************************/
void Hash::del(Object *k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	if (exist) {
		keys[pos]->del_ref();
		if (values[pos]) values[pos]->del_ref();
		int32 i;
		size--;
		for (i=pos;i!=size;i++) {
			keys[i]=keys[i+1];
			values[i]=values[i+1];
		}
	}

}

/*****************************************************************************/
bool Hash::exist(Object *k)
{
	bool exist;
	int32 pos;
	get_pos(k,pos,exist);
	return exist;
}

/*****************************************************************************/
void Hash::get_pos(Object *k,int32 &pos,bool &exist)
{
	int16 a;
	int32 p1;
	int32 p2;
	if (size==0) {
		pos=0;
		exist=false;
		return;
	}
	if (size==1) {
		a=k->cmp(keys[0]);
		if (a==0) {
			exist=true;pos=0;
		} else {
			exist=false;
			pos=(a<0)?0:1;
		}
		return;
	}
	p1=0;
	p2=size-1;
	a=k->cmp(keys[p1]);
	if (a<0) {
		exist=false;
		pos=p1;
		return;
	} else if (a==0) {
		exist=true;
		pos=p1;
		return;
	}
	a=k->cmp(keys[p2]);
	if (a>0) {
		exist=false;
		pos=p2+1;
		return;
	} else if (a==0) {
		exist=true;
		pos=p2;
		return;
	}
	while (p2-p1>1) {
		int32 c=(p2+p1)>>1;
		a=k->cmp(keys[c]);
//		printf("[p1=%d c=%d p2=%d]=%d (full=%d)\n",p1,c,p2,a,size);
		if (a==0) {
			pos=c;
			exist=true;
			return;
		} else if (a>0) {
			p1=c;
		} else {
			p2=c;
		}
	}
	exist=false;
	pos=p2;
}

/*****************************************************************************/
const char *Hash::classname()
{
	return "Hash";
}

/*****************************************************************************/
Array *Hash::get_keys()
{
	Array *r=new Array();
	r->grow(size);
	uint32 i;
	for (i=0;i!=size;i++) {
		r->put(i,keys[i]);
	}
	return r;
}

/*****************************************************************************/
Array *Hash::get_values()
{
	Array *r=new Array();
	r->grow(size);
	uint32 i;
	for (i=0;i!=size;i++) {
		r->put(i,values[i]);
	}
	return r;
}


/*****************************************************************************/
void Hash::print_keys()
{
	uint32 i;
	printf("Hash::print_keys():\n");
	for (i=0;i!=size;i++) {
		Text *t=dynamic_cast<Text*>(keys[i]);
		if (t) {
			printf("[%d]='",i);
			t->print();
			printf("'\n");
		} else {
			printf("[%d]=%s::%xh\n",i,keys[i]->classname(),(ptrsize)keys[i]);
		}
	}
}

/*****************************************************************************/
bool Hash::storable_to_blob(Blob *b)
{
	b->add_bytes((const uint8*)(&size),4);
	b->word_align();
	for (uint32 i=0;i<size;i++) {
		if (keys[i]->storable_to_blob(b)) return true;
		if (values[i]->storable_to_blob(b)) return true;
	}
	return false;
}

/*****************************************************************************/

