#include <atoms/random_sequence.h>

RandomSequence::RandomSequence()
{
	length=0;
	data=NULL;
}

RandomSequence::RandomSequence(uint32 len)
{
	length=len;
	data=NULL;
	init();
}

void RandomSequence::init()
{
	uint32 i;
	if (data) free(data);
	if (length) {
		data=(uint32*)malloc(sizeof(uint32)*length);
		for (i=0;i<length;i++) data[i]=i;
//		memset(data,0,sizeof(uint32)*length);
	} else {
		data=NULL;
	}
}

RandomSequence::~RandomSequence()
{
	if (data) free(data);
}

const char *RandomSequence::classname()
{
	return "RandomSequence";
}

bool RandomSequence::has_next(void)
{
	if (length==0) return false;
	return true;
}

int32 RandomSequence::next(void)
{
	uint32 i,pos,ret;
	if (length==0) return -1;
	pos=rand()%length;
	ret=data[pos];
	length--;
	if (pos!=length) {
		data[pos]=data[length];
		data[length]=ret;
	}
	return ret;
}


