#include <stdio.h>
#include <atoms/regexp.h>
#include <atoms/text8.h>
#include <atoms/text32.h>
#include <atoms/blob.h>
#include <atoms/funcs.h>
#include <atoms/array.h>

#define OVECCOUNT 300

Regexp::Regexp(Text *t,uint32 flags)
{
	const char *error;
	char *pattern;
	int erroffset;
	int flags1=0;
	Text *t8=dynamic_cast<Text8*>(t);
	Text *t32=dynamic_cast<Text32*>(t);
	Text *tb=dynamic_cast<Blob*>(t);
	if (t8) {
		flags1+=PCRE_UTF8;
		pattern=t8->get_chars();
	} else if (t32) {
		t8=text_to_text8(t);
		t8->add_ref();
		pattern=t8->get_chars();
		t8->del_ref();
	} else if (tb) {
		pattern=tb->get_chars();
	} else {
		assert(0);
	}
	re=pcre_compile(pattern,flags1,&error,&erroffset,NULL/* use default character tables */);
	if (re==NULL) {
		printf("PCRE compilation failed at offset %d: %s\n", erroffset, error);
	}
	free(pattern);
	extra=NULL;
}

Regexp::Regexp(char *pattern,uint32 flags)
{
	const char *error;
	int erroffset;
	int flags1=0;
	re=pcre_compile(pattern,flags1,&error,&erroffset,NULL/* use default character tables */);
	if (re==NULL) {
		printf("PCRE compilation failed at offset %d: %s\n", erroffset, error);
	}
	extra=NULL;
}

Regexp::~Regexp()
{
	if (re) pcre_free(re);
//	if (extra)  TODO?
}

const char *Regexp::classname()
{
	return "Regexp";
}

void Regexp::study(void)
{
	int flags=0;
	const char *error;
	extra=pcre_study(re,flags,&error);
}

bool Regexp::match(Text *t,Array *array)
{
	int ovector[OVECCOUNT];
	int rc;
	int offset=0;
	int options=0;

	char *subject;
	int subject_length;
	bool retflag;
	
	Text *t8del=NULL;
	Text8 *t8=dynamic_cast<Text8*>(t);
	Text32 *t32=dynamic_cast<Text32*>(t);
	Blob *tb=dynamic_cast<Blob*>(t);
	if (t8) {
		subject=(char*)t8->text;
		subject_length=t8->size_bytes;
	} else if (t32) {
		t8del=text_to_text8(t32);
		t8del->add_ref();
		subject=(char*)t8->text;
		subject_length=t8->size_bytes;
	} else if (tb) {
		subject=(char*)tb->text;
		subject_length=tb->length;
	} else {
		assert(0);
	}
	rc = pcre_exec(re,extra,subject,subject_length,offset,options,ovector,OVECCOUNT);
	if (rc==PCRE_ERROR_NOMATCH) {
		retflag=false;
		goto END;
	} else if (rc<0) {
		retflag=false;
		printf("Matching error %d\n", rc);
		goto END;
	}
	retflag=true;
	if (array && rc>0) {
		for (int i=0;i<rc;i++) {
			char *substring_start = subject + ovector[2*i];
			int substring_length = ovector[2*i+1] - ovector[2*i];
			Text *t;
			if (tb) {
				t=new Blob(substring_start,substring_length);
			} else {
				t=new Text8(substring_start,substring_length);
			}
			array->push(t);
//			printf("%2d: %.*s\n", i, substring_length, substring_start);
		}
	}
END:
	if (t8del) t8del->del_ref();
	return retflag;
}

Array *Regexp::split(Text *t)
{

}

