#include <sys/types.h>
#include <sys/socket.h>
#include <atoms/socket.h>

/*****************************************************************************/
Socket::Socket()
{
	fd=-1;
	old_fd=-1;
}

/*****************************************************************************/
Socket::~Socket()
{
	close();
}

/*****************************************************************************/
void Socket::close(void)
{
	if (fd!=-1) old_fd=fd;
	fd=-1;
}

/*****************************************************************************/
bool Socket::send(Blob *b,int32 flags)
{
	if (fd==-1) return false;
	return send(b->text,b->length,flags);
}

/*****************************************************************************/
bool Socket::send(const uint8 *data,uint32 size,int32 flags)
{
	flags|=MSG_NOSIGNAL;
	if (fd==-1) return false;
	int r=::send(fd,data,size,flags);
	if (r==-1) close();
	return r?true:false;
}

/*****************************************************************************/
bool Socket::send(const char *data,uint32 size,int32 flags)
{
	if (fd==-1) return false;
	return send((uint8*)data,size,flags);
}

/*****************************************************************************/
bool Socket::send(const char *data)
{
	if (fd==-1) return false;
	int32 flags=0;
	int size=strlen(data);
	return send((uint8*)data,size,flags);
}


/*****************************************************************************/
Blob *Socket::recv(uint32 maxsize,uint32 flags)
{
	if (fd==-1) return NULL;
	uint8 *recvbuff;
	Blob *r=NULL;
	if (maxsize<=800) recvbuff=tmp; else recvbuff=(uint8*)malloc(maxsize);
	int32 s=::recv(fd,(void*)recvbuff,maxsize,flags);
	if (s>0) r=new Blob(recvbuff,s);
	if (s<0) close();
	if (maxsize>800) free(recvbuff);
	return r;
}

/*****************************************************************************/
int Socket::get_fd()
{
	return fd;
}

/*****************************************************************************/
bool Socket::connected()
{
	return fd==-1?false:true;
}

/*****************************************************************************/
int Socket::get_fd_or_old()
{
	if (fd!=-1) return fd;
	return old_fd;
}

/*****************************************************************************/
	
