#include <atoms/utf.h>
#include <errno.h>
#include <string.h>

bool issymbol (uint8* b, int len)
{
	if (!(b[0] & 0x80)) return true;

	if (len < 2) return false;
	if ((b[0] & 0x80) && !(b[0] & 0x40) && (b[1] & 0x80) && !(b[1] & 0x40)) return true;

	if (len < 3) return false;
	if ((b[0] & 0x80) && (b[0] & 0x40) && !(b[0] & 0x20) 
		&& (b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40))  return true; 
	
	if (len < 4) return false;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && !(b[0] & 0x10) && 
			(b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40))  return true;
 
	if (len < 5) return false;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && (b[0] & 0x10) && !(b[0] & 0x08) && 
			(b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40) &&  
			(b[4] & 0x80) && !(b[4] & 0x40))  return true;
	 
	if (len < 6) return false;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && (b[0] & 0x10) && (b[0] & 0x08) && !(b[0] & 0x04)
			&& (b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40)  
			&& (b[4] & 0x80) && !(b[4] & 0x40) && (b[5] & 0x80) && !(b[5] & 0x40))  return true;

	return false;
}//issymbol

bool comparesym (uint8* b, int len, uint32 s)
{
	return symbol(b, len) == s;
}//comparesym

uint32 symbol (uint8* b, int len)
{
	if (!(b[0] & 0x80)) return b[0];

	if (len < 2) return (uint32) -1;
	if ((b[0] & 0x80) && !(b[0] & 0x40) && (b[1] & 0x80) && !(b[1] & 0x40)) 
	return (b[0] & 0x1F) << 6 + b[1] & 0x3F; 

	if (len < 3) return (uint32) -1;
	if ((b[0] & 0x80) && (b[0] & 0x40) && !(b[0] & 0x20) && 
		 (b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40)) 
	return (b[0] & 0x0F) << 12 + (b[1] & 0x3F) << 6 + b[2] & 0x3F; 
	
	if (len < 4) return (uint32) -1;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && !(b[0] & 0x10) && 
			 (b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40))  
	return (b[0] & 0x08) << 18 + (b[1] & 0x3F) << 12 + (b[2] & 0x3F) << 6 + b[3] & 0x3F ;
 
	if (len < 5) return (uint32) -1;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && (b[0] & 0x10) && !(b[0] & 0x08) && 
			(b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40) &&  
			(b[4] & 0x80) && !(b[4] & 0x40))  
	return (b[0] & 0x04) << 24 + (b[1] & 0x3F) << 18 + (b[2] & 0x3F) << 12 + (b[3] & 0x3F) << 6 + b[4] & 0x3F;
	 
	if (len < 6) return (uint32) -1;
	if ((b[0] & 0x80) && (b[0] & 0x40) && (b[0] & 0x20) && (b[0] & 0x10) && (b[0] & 0x08) && !(b[0] & 0x04) &&
			(b[1] & 0x80) && !(b[1] & 0x40) && (b[2] & 0x80) && !(b[2] & 0x40) && (b[3] & 0x80) && !(b[3] & 0x40) &&  
			(b[4] & 0x80) && !(b[4] & 0x40) && (b[5] & 0x80) && !(b[5] & 0x40))  
	return (b[0] & 0x02) << 30 + (b[1] & 0x3F) << 24 + (b[2] & 0x3F) << 18 + (b[3] & 0x3F) << 12 + (b[4] & 0x3F) << 6 + b[5] & 0x3F;

	return (uint32) -1;
}//symbol

/*
	if ((text[p]&0x10000000)==0) {
		r=text[p];
	} else if ((text[p]&0x11100000)==0x11000000) {
		r=(text[p]&0x00011111)<<6+text[p+1]&0x00111111;
	} else if ((text[p]&0x11110000)==0x11100000) {
		r=(text[p]&0x00001111)<<12+(text[p+1]&0x00111111)<<6+text[p+2]&0x00111111;
	} else if ((text[p]&0x11111000)==0x11110000) {
		r=(text[p]&0x00000111)<<18+(text[p+1]&0x00111111)<<12+(text[p+2]&0x00111111)<<6+text[p+3]&0x00111111;
	} else if ((text[p]&0x11111100)==0x11111000) {
		r=(text[p]&0x00000011)<<24+(text[p+1]&0x00111111)<<18+(text[p+2]&0x00111111)<<12+(text[p+3]&0x00111111)<<6+text[p+4]&0x00111111;
	} else if ((text[p]&0x11111110)==0x11111100) {
		r=(text[p]&0x00000001)<<30+(text[p+1]&0x00111111)<<24+(text[p+2]&0x00111111)<<18+(text[p+3]&0x00111111)<<12+(text[p+4]&0x00111111)<<6+text[p+5]&0x00111111;
	}
	return r;
*/

void print64 (uint64 m)
{
	union MaskUn
	{
		uint64 mask;
		uint8 mask_bytes[8];
	} maskun;
	maskun.mask = m;
	for (int i=0; i<8; i++)
	{
		printf ("\t%x", maskun.mask_bytes[i]);
	}
	printf ("\n");
}//print64

void print_arr (uint8* p, int len)
{
	for (int i=0; i<len; i++)
	{
		printf ("%x  ", p[i]);
	}
	printf ("\n\n");
}//print

bool msg_return (const char* c, bool r)
{
	printf("%s %s\n", c, strerror(errno));
}
