#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"

/**
 * Method: IncentSource::new
 */
IncentSource::IncentSource()
{
	do_free=false;
}

/**
 * Method: IncentSource::delete
 */
IncentSource::~IncentSource()
{
	if (do_free) {
		free(name);
	}
}

/**
 * Method: IncentSource::load
 */
bool IncentSource::load(ReadStream *s)
{
	id						=s->read_int64();
	name					=s->read_charptr();
}

/**
 * Method: IncentSource::save
 */
bool IncentSource::save(WriteStream *s)
{
	s->write_int64(id);
	s->write_charptr(name);
}

/**
 * Method: IncentSource::load
 */
bool IncentSource::load(PGresult *res,int row)
{
	do_free=true;
	id						=atol(PQgetvalue(res,row,0));
	name					=strdup(PQgetvalue(res,row,1));
}

const char *IncentSource::classname() { return "IncentSource"; }

