#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "offermon/memcache.h"

/**
 * Method: Offer::new
 */
Offer::Offer()
{
//	regions=NULL;
	do_free=false;
	rr_offers=NULL;
	rr_offer_pos=0;
	rr_offer_max=0;
}

/**
 * Method: Offer::delete
 */
Offer::~Offer()
{
//	if (regions) free(regions);
	if (do_free) {
		free(tracking_url);
		free(app_name);
		free(app_description);
		free(app_cover_image);
		free(app_genre_name);
	}
	if (rr_offers) free(rr_offers);
}

/**
 * Method: Offer::init
 */
void Offer::init(int max_region_id)
{
	if (max_region_id>REGIONS_SIZE*8) {
		fprintf(stderr,"TOO MANY REGIONS (%d vs %d)!\n",max_region_id,REGIONS_SIZE*8);
		exit(1);
	}
//	regions_size=(max_region_id>>3)+2;
//	regions=(char*)malloc(regions_size);
//	memset(regions,0,regions_size);
	memset(regions,0,REGIONS_SIZE);
	devices=0;
}

/**
 * Method: Offer::load
 */
bool Offer::load(ReadStream *s)
{
	int32 cnt,i;
	id					=s->read_int64();
	engine_id			=s->read_int64();
	devices				=s->read_int64();
	tracking_url		=s->read_charptr();
	app_name			=s->read_charptr();
	app_description		=s->read_charptr();
	app_cover_image		=s->read_charptr();
	app_genre_name		=s->read_charptr();
	app_installs		=s->read_int32();
	app_rating_count	=s->read_int32();
	app_rating_percent	=s->read_int32();
	is_ios				=s->read_int32();
	is_android			=s->read_int32();
	payout_usd			=0.0001*s->read_int32();
	payout				=0.0001*s->read_int32();
	currency_id			=s->read_int32();

	cnt=s->read_int32();
	for (i=0;i<cnt;i++) {
		set_region(s->read_int32());
	}
	rr_offer_max		=s->read_int32();
	if (rr_offer_max) rr_offers=(int64*)malloc(sizeof(int64)*rr_offer_max);
	for (i=0;i<rr_offer_max;i++) {
		rr_offers[i]=s->read_int64();
	}
}

/**
 * Method: Offer::save
 */
bool Offer::save(WriteStream *s)
{
	int i,cnt_regions,j,a;
	s->write_int64(id);
	s->write_int64(engine_id);
	s->write_int64(devices);
	s->write_charptr(tracking_url);
	s->write_charptr(app_name);
	s->write_charptr(app_description);
	s->write_charptr(app_cover_image);
	s->write_charptr(app_genre_name);
	s->write_int32(app_installs);
	s->write_int32(app_rating_count);
	s->write_int32(app_rating_percent);
	s->write_int32(is_ios);
	s->write_int32(is_android);
	s->write_int32(payout_usd*10000);
	s->write_int32(payout*10000);
	s->write_int32(currency_id);

	cnt_regions=0;

	for (i=0;i<regions_size;i++) {
		a=1;
		for (j=0;j<8;j++) {
			if (regions[i]&a) cnt_regions++;
			a<<=1;
		}
	}
	s->write_int32(cnt_regions);
	for (i=0;i<regions_size;i++) {
		for (j=0;j<8;j++) {
			if (regions[i]&a) s->write_int32(1<<(j*8+i));
		}
	}
	s->write_int32(rr_offer_max);
	for (i=0;i<rr_offer_max;i++) {
		s->write_int64(rr_offers[i]);
	}
}

/**
 * Method: Offer::load
 */
bool Offer::load(PGresult *res,int row)
{
	char *tmp;
	int pos,ppos;
	Offer *t=this;
	do_free=true;
	
	id					=atol(  PQgetvalue(res,row,0));
	engine_id			=atol(  PQgetvalue(res,row,1));
	tracking_url		=strdup(PQgetvalue(res,row,2));
	app_name			=strdup(PQgetvalue(res,row,5));
	app_genre_name		=strdup(PQgetvalue(res,row,6));
	app_description		=strdup(PQgetvalue(res,row,7));
	app_installs		=atoi(  PQgetvalue(res,row,8));
	app_rating_count	=atoi(  PQgetvalue(res,row,9));
	app_rating_percent	=atoi(  PQgetvalue(res,row,10));
	app_cover_image		=strdup(PQgetvalue(res,row,11));
	is_ios				=atoi(  PQgetvalue(res,row,12));
	is_android			=atoi(  PQgetvalue(res,row,13));
	payout_usd			=atof(  PQgetvalue(res,row,15));
	payout				=atof(  PQgetvalue(res,row,16));
	currency_id			=atoi(  PQgetvalue(res,row,17));
/*	void (*regions_builder)(int64 val)=[this](int64 val)
	{
		set_region(val);
	};
	on_each_int64(PQgetvalue(res,row,3),[t](int64 val){ t->set_region(val);});*/
	tmp=PQgetvalue(res,row,3);
//	if (id==520293) printf("	OFFER #%d - regions='%s'\n",id,tmp);
	pos=ppos=0;
	while (tmp[pos]) {
		if (tmp[pos]==',') {
			if (ppos!=pos) set_region(atol(tmp+ppos));
			ppos=pos+1;
		}
		pos++;
	}
	if (ppos!=pos) set_region(atol(tmp+ppos));

	tmp=PQgetvalue(res,row,4);
	pos=ppos=0;
	while (tmp[pos]) {
		if (tmp[pos]==',') {
			if (ppos!=pos) set_device(atol(tmp+ppos));
			ppos=pos+1;
		}
		pos++;
	}
	if (ppos!=pos) set_device(atol(tmp+ppos));

	tmp=PQgetvalue(res,row,14);
	rr_offer_max=0;
	pos=0;
	while (tmp[pos]) {
		if (tmp[pos]==',') rr_offer_max++;
		pos++;
	}
	if (rr_offer_max) {
		rr_offer_max=0;
		rr_offers=(int64*)malloc(sizeof(int64)*rr_offer_max);
		pos=ppos=0;
		while (tmp[pos]) {
			if (tmp[pos]==',') {
				if (ppos!=pos) {
					rr_offers[rr_offer_max]=atol(tmp+ppos);
					rr_offer_max++;
				}
				ppos=pos+1;
			}
			pos++;
		}
		if (ppos!=pos) {
			rr_offers[rr_offer_max]=atol(tmp+ppos);
			rr_offer_max++;
		}
	}
}

/**
 * Method: Offer::set_region
 *		Устанавливает регион
 */
void Offer::set_region(uint region_id)
{
	uint bitno,byteno;
	bitno=region_id&7;
	byteno=region_id>>3;
	regions[byteno]=regions[byteno] | (1<<bitno);
}

/**
 * Method: Offer::get_region
 *		Проверяет регион
 */
bool Offer::get_region(uint region_id)
{
	uint bitno,byteno;
	bitno=region_id&7;
	byteno=region_id>>3;
	return regions[byteno] & (1<<bitno);
}

/**
 * Method: Offer::set_device
 *		Устанавливает девайс
 */
void Offer::set_device(int device_id)
{
	devices=devices | (1<<device_id);
	if (device_id==6) {
		devices=devices | (1<<1);
		devices=devices | (1<<2);
		devices=devices | (1<<3);
	}
}

/**
 * Method: Offer::get_device
 *		Проверяет девайс
 */
bool Offer::get_device(int device_id)
{
	return (devices & (1<<device_id));
}

const char *Offer::classname(void) { return "Offer"; };


